/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointNumericTermsEnum;
import org.apache.lucene.spatial.geopoint.search.GeoPointPrefixTermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

abstract class GeoPointTermsEnum
extends FilteredTermsEnum {
    protected final short maxShift;
    protected BaseRange currentRange;
    protected BytesRef currentCell;
    protected final BytesRefBuilder currentCellBRB = new BytesRefBuilder();
    protected final BytesRefBuilder nextSubRangeBRB = new BytesRefBuilder();
    protected final GeoPointMultiTermQuery.CellComparator relationImpl;

    GeoPointTermsEnum(TermsEnum tenum, GeoPointMultiTermQuery query) {
        super(tenum);
        this.maxShift = query.maxShift;
        this.relationImpl = query.cellComparator;
    }

    static GeoPointTermsEnum newInstance(TermsEnum terms, GeoPointMultiTermQuery query) {
        if (query.termEncoding == GeoPointField.TermEncoding.PREFIX) {
            return new GeoPointPrefixTermsEnum(terms, query);
        }
        if (query.termEncoding == GeoPointField.TermEncoding.NUMERIC) {
            return new GeoPointNumericTermsEnum(terms, query);
        }
        throw new IllegalArgumentException("Invalid GeoPoint TermEncoding " + (Object)((Object)query.termEncoding));
    }

    public boolean boundaryTerm() {
        if (this.currentCell == null) {
            throw new IllegalStateException("GeoPointTermsEnum empty or not initialized");
        }
        return this.currentRange.boundary;
    }

    protected BytesRef peek() {
        return this.nextSubRangeBRB.get();
    }

    protected abstract boolean hasNext();

    protected void nextRange() {
        this.currentRange.fillBytesRef(this.currentCellBRB);
        this.currentCell = this.currentCellBRB.get();
    }

    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        while (this.currentCell == null || term.compareTo(this.currentCell) > 0) {
            if (!this.hasNext()) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            if (term.compareTo(this.peek()) < 0) {
                return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
            }
            this.nextRange();
        }
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    protected boolean postFilter(double lat, double lon) {
        return this.relationImpl.postFilter(lat, lon);
    }

    abstract class BaseRange
    implements Comparable<BaseRange> {
        protected short shift;
        protected long start;
        protected boolean boundary;

        BaseRange(long lower, short shift, boolean boundary) {
            this.boundary = boundary;
            this.start = lower;
            this.shift = shift;
        }

        protected abstract void fillBytesRef(BytesRefBuilder var1);

        @Override
        public int compareTo(BaseRange other) {
            int result = Short.compare(this.shift, other.shift);
            if (result == 0) {
                return Long.compare(this.start, other.start);
            }
            return result;
        }

        protected void set(BaseRange other) {
            this.start = other.start;
            this.shift = other.shift;
            this.boundary = other.boundary;
        }
    }
}

