/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.spatial.util.GeoEncodingUtils;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;

final class GeoPointTermQueryConstantScoreWrapper<Q extends GeoPointMultiTermQuery>
extends Query {
    protected final Q query;

    protected GeoPointTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    public Q getQuery() {
        return this.query;
    }

    public String toString(String field) {
        return this.query.toString();
    }

    public final boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GeoPointTermQueryConstantScoreWrapper that = (GeoPointTermQueryConstantScoreWrapper)((Object)o);
        return this.query.equals(that.query);
    }

    public final int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(GeoPointTermQueryConstantScoreWrapper.this.query.getField());
                if (terms == null) {
                    return null;
                }
                GeoPointTermsEnum termsEnum = (GeoPointTermsEnum)((GeoPointMultiTermQuery)((Object)GeoPointTermQueryConstantScoreWrapper.this.query)).getTermsEnum(terms, null);
                assert (termsEnum != null);
                LeafReader reader = context.reader();
                DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc());
                Object preApproved = (long)terms.getDocCount() * 100L < (long)reader.maxDoc() ? new SparseFixedBitSet(reader.maxDoc()) : new FixedBitSet(reader.maxDoc());
                PostingsEnum docs = null;
                while (termsEnum.next() != null) {
                    int docId;
                    docs = termsEnum.postings(docs, 0);
                    if (termsEnum.boundaryTerm()) {
                        builder.add((DocIdSetIterator)docs);
                        continue;
                    }
                    while ((docId = docs.nextDoc()) != Integer.MAX_VALUE) {
                        builder.add(docId);
                        preApproved.set(docId);
                    }
                }
                DocIdSet set = builder.build();
                final DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                SortedNumericDocValues sdv = reader.getSortedNumericDocValues(GeoPointTermQueryConstantScoreWrapper.this.query.getField());
                TwoPhaseIterator iterator = new TwoPhaseIterator(disi, (BitSet)preApproved, sdv, termsEnum){
                    final /* synthetic */ BitSet val$preApproved;
                    final /* synthetic */ SortedNumericDocValues val$sdv;
                    final /* synthetic */ GeoPointTermsEnum val$termsEnum;
                    {
                        this.val$preApproved = bitSet;
                        this.val$sdv = sortedNumericDocValues;
                        this.val$termsEnum = geoPointTermsEnum;
                        super(x0);
                    }

                    public boolean matches() throws IOException {
                        int docId = disi.docID();
                        if (this.val$preApproved.get(docId)) {
                            return true;
                        }
                        this.val$sdv.setDocument(docId);
                        int count = this.val$sdv.count();
                        for (int i = 0; i < count; ++i) {
                            long hash = this.val$sdv.valueAt(i);
                            if (!this.val$termsEnum.postFilter(GeoEncodingUtils.mortonUnhashLat(hash), GeoEncodingUtils.mortonUnhashLon(hash))) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 20.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

