/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.util.GeoRelationUtils;

final class GeoPointInPolygonQueryImpl
extends GeoPointInBBoxQueryImpl {
    private final GeoPointInPolygonQuery polygonQuery;

    GeoPointInPolygonQueryImpl(String field, GeoPointField.TermEncoding termEncoding, GeoPointInPolygonQuery q, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, termEncoding, minLat, maxLat, minLon, maxLon);
        this.polygonQuery = q;
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPolygonCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInPolygonQueryImpl that = (GeoPointInPolygonQueryImpl)((Object)o);
        return !(this.polygonQuery == null ? that.polygonQuery != null : !this.polygonQuery.equals((Object)that.polygonQuery));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.polygonQuery != null ? this.polygonQuery.hashCode() : 0);
        return result;
    }

    private final class GeoPolygonCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPolygonCellComparator(GeoPointMultiTermQuery query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectCrossesPolyApprox(minLat, maxLat, minLon, maxLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLats, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLons, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLon);
        }

        @Override
        protected boolean cellWithin(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectWithinPolyApprox(minLat, maxLat, minLon, maxLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLats, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLons, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLon);
        }

        @Override
        protected boolean cellIntersectsShape(double minLat, double maxLat, double minLon, double maxLon) {
            return this.cellContains(minLat, maxLat, minLon, maxLon) || this.cellWithin(minLat, maxLat, minLon, maxLon) || this.cellCrosses(minLat, maxLat, minLon, maxLon);
        }

        @Override
        protected boolean postFilter(double lat, double lon) {
            return GeoRelationUtils.pointInPolygon(((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLats, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.polyLons, lat, lon);
        }
    }
}

