/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.prefix.CellToBytesRefIterator;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    protected boolean simplifyIndexedCells = false;

    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
    }

    @Override
    protected CellToBytesRefIterator newCellToBytesRefIterator() {
        return new CellToBytesRefIterator(){

            @Override
            public BytesRef next() {
                if (!this.cellIter.hasNext()) {
                    return null;
                }
                return ((Cell)this.cellIter.next()).getTokenBytesNoLeaf(this.bytesRef);
            }
        };
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (op != SpatialOperation.Intersects) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        int GUESS_NUM_TERMS = shape instanceof Point ? detailLevel : 4096;
        BytesRefBuilder masterBytes = new BytesRefBuilder();
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>(GUESS_NUM_TERMS);
        CellIterator cells = this.grid.getTreeCellIterator(shape, detailLevel);
        while (cells.hasNext()) {
            Cell cell = cells.next();
            if (!cell.isLeaf()) continue;
            BytesRef term = cell.getTokenBytesNoLeaf(null);
            masterBytes.grow(masterBytes.length() + term.length);
            masterBytes.append(term);
            term.bytes = null;
            term.offset = masterBytes.length() - term.length;
            terms.add(term);
        }
        for (BytesRef byteRef : terms) {
            byteRef.bytes = masterBytes.bytes();
        }
        return new QueryWrapperFilter((Query)new TermsQuery(this.getFieldName(), terms));
    }
}

