/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.exception.InvalidSpatialArgument;
import com.spatial4j.core.shape.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialArgsParser {
    public SpatialArgs parse(String v, SpatialContext ctx) throws InvalidSpatialArgument, InvalidShapeException {
        int idx = v.indexOf(40);
        int edx = v.lastIndexOf(41);
        if (idx < 0 || idx > edx) {
            throw new InvalidSpatialArgument("missing parens: " + v, null);
        }
        SpatialOperation op = SpatialOperation.get(v.substring(0, idx).trim());
        String body = v.substring(idx + 1, edx).trim();
        if (body.length() < 1) {
            throw new InvalidSpatialArgument("missing body : " + v, null);
        }
        Shape shape = ctx.readShape(body);
        SpatialArgs args = new SpatialArgs(op, shape);
        if (v.length() > edx + 1 && (body = v.substring(edx + 1).trim()).length() > 0) {
            Map<String, String> aa = SpatialArgsParser.parseMap(body);
            args.setMin(SpatialArgsParser.readDouble(aa.remove("min")));
            args.setMax(SpatialArgsParser.readDouble(aa.remove("max")));
            args.setDistPrecision(SpatialArgsParser.readDouble(aa.remove("distPrec")));
            if (!aa.isEmpty()) {
                throw new InvalidSpatialArgument("unused parameters: " + aa, null);
            }
        }
        return args;
    }

    protected static Double readDouble(String v) {
        return v == null ? null : Double.valueOf(v);
    }

    protected static boolean readBool(String v, boolean defaultValue) {
        return v == null ? defaultValue : Boolean.parseBoolean(v);
    }

    protected static Map<String, String> parseMap(String body) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(body, " \n\t");
        while (st.hasMoreTokens()) {
            String a = st.nextToken();
            int idx = a.indexOf(61);
            if (idx > 0) {
                String k = a.substring(0, idx);
                String v = a.substring(idx + 1);
                map.put(k, v);
                continue;
            }
            map.put(a, a);
        }
        return map;
    }
}

