/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import java.util.Map;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;

public abstract class SpatialPrefixTreeFactory {
    private static final double DEFAULT_GEO_MAX_DETAIL_KM = 0.001;
    protected Map<String, String> args;
    protected SpatialContext ctx;
    protected Integer maxLevels;

    public static SpatialPrefixTree makeSPT(Map<String, String> args, ClassLoader classLoader, SpatialContext ctx) {
        SpatialPrefixTreeFactory instance;
        String cname = args.get("prefixTree");
        if (cname == null) {
            String string = cname = ctx.isGeo() ? "geohash" : "quad";
        }
        if ("geohash".equalsIgnoreCase(cname)) {
            instance = new GeohashPrefixTree.Factory();
        } else if ("quad".equalsIgnoreCase(cname)) {
            instance = new QuadPrefixTree.Factory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialPrefixTreeFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args, ctx);
        return instance.newSPT();
    }

    protected void init(Map<String, String> args, SpatialContext ctx) {
        this.args = args;
        this.ctx = ctx;
        this.initMaxLevels();
    }

    protected void initMaxLevels() {
        double degrees;
        String mlStr = this.args.get("maxLevels");
        if (mlStr != null) {
            this.maxLevels = Integer.valueOf(mlStr);
            return;
        }
        String maxDetailDistStr = this.args.get("maxDetailDist");
        if (maxDetailDistStr == null) {
            if (!this.ctx.isGeo()) {
                return;
            }
            degrees = DistanceUtils.dist2Degrees((double)0.001, (double)6371.0087714);
        } else {
            degrees = Double.parseDouble(maxDetailDistStr);
            if (this.ctx.isGeo()) {
                degrees = DistanceUtils.dist2Degrees((double)Double.parseDouble(maxDetailDistStr), (double)6371.0087714);
            }
        }
        this.maxLevels = this.getLevelForDistance(degrees);
    }

    protected abstract int getLevelForDistance(double var1);

    protected abstract SpatialPrefixTree newSPT();
}

