/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial;

import org.apache.lucene.spatial.geometry.DistanceUnits;
import org.apache.lucene.spatial.geometry.FloatLatLng;
import org.apache.lucene.spatial.geometry.shape.LLRect;
import org.apache.lucene.spatial.geometry.shape.Rectangle;
import org.apache.lucene.spatial.tier.InvalidGeoException;

public class DistanceUtils {
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEG_45_AS_RADS = 0.7853981633974483;
    public static final double SIN_45_AS_RADS = Math.sin(0.7853981633974483);
    public static final double DEG_90_AS_RADS = 1.5707963267948966;
    public static final double DEG_180_AS_RADS = Math.PI;
    public static final double DEG_225_AS_RADS = 3.9269908169872414;
    public static final double DEG_270_AS_RADS = 4.71238898038469;
    public static final double KM_TO_MILES = 0.621371192;
    public static final double MILES_TO_KM = 1.609344;
    public static final double EARTH_MEAN_RADIUS_KM = 6371.009;
    public static final double EARTH_MEAN_RADIUS_MI = 3958.7614580847844;
    public static final double EARTH_EQUATORIAL_RADIUS_MI = 3963.205;
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.16018752;

    public static double getDistanceMi(double x1, double y1, double x2, double y2) {
        return DistanceUtils.getLLMDistance(x1, y1, x2, y2);
    }

    public static Rectangle getBoundary(double x1, double y1, double miles) {
        LLRect box = LLRect.createBox(new FloatLatLng(x1, y1), miles, miles);
        return box.toRectangle();
    }

    public static double getLLMDistance(double x1, double y1, double x2, double y2) {
        FloatLatLng p1 = new FloatLatLng(x1, y1);
        FloatLatLng p2 = new FloatLatLng(x2, y2);
        return p1.arcDistance(p2, DistanceUnits.MILES);
    }

    public static double angularDistance(double distance, double radius) {
        return distance / radius;
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power) {
        return DistanceUtils.vectorDistance(vec1, vec2, power, 1.0 / power);
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power, double oneOverPower) {
        double result = 0.0;
        if (power == 0.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += vec1[i] - vec2[i] == 0.0 ? 0.0 : 1.0;
            }
        } else if (power == 1.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += vec1[i] - vec2[i];
            }
        } else if (power == 2.0) {
            result = Math.sqrt(DistanceUtils.squaredEuclideanDistance(vec1, vec2));
        } else if (power == 2.147483647E9 || Double.isInfinite(power)) {
            for (int i = 0; i < vec1.length; ++i) {
                result = Math.max(result, Math.max(vec1[i], vec2[i]));
            }
        } else {
            for (int i = 0; i < vec1.length; ++i) {
                result += Math.pow(vec1[i] - vec2[i], power);
            }
            result = Math.pow(result, oneOverPower);
        }
        return result;
    }

    public static double[] vectorBoxCorner(double[] center, double[] result, double distance, boolean upperRight) {
        if (result == null || result.length != center.length) {
            result = new double[center.length];
        }
        if (!upperRight) {
            distance = -distance;
        }
        distance = SIN_45_AS_RADS * distance;
        for (int i = 0; i < center.length; ++i) {
            result[i] = center[i] + distance;
        }
        return result;
    }

    public static double[] latLonCornerDegs(double latCenter, double lonCenter, double distance, double[] result, boolean upperRight, double sphereRadius) {
        result = DistanceUtils.latLonCorner(latCenter * (Math.PI / 180), lonCenter * (Math.PI / 180), distance, result, upperRight, sphereRadius);
        result[0] = result[0] * 57.29577951308232;
        result[1] = result[1] * 57.29577951308232;
        return result;
    }

    public static double[] latLonCorner(double latCenter, double lonCenter, double distance, double[] result, boolean upperRight, double sphereRadius) {
        double brng = upperRight ? 0.7853981633974483 : 3.9269908169872414;
        result = DistanceUtils.pointOnBearing(latCenter, lonCenter, distance, brng, result, sphereRadius);
        return result;
    }

    public static double[] pointOnBearing(double startLat, double startLon, double distance, double bearing, double[] result, double sphereRadius) {
        double cosAngDist = Math.cos(distance / sphereRadius);
        double cosStartLat = Math.cos(startLat);
        double sinAngDist = Math.sin(distance / sphereRadius);
        double lat2 = Math.asin(Math.sin(startLat) * cosAngDist + cosStartLat * sinAngDist * Math.cos(bearing));
        double lon2 = startLon + Math.atan2(Math.sin(bearing) * sinAngDist * cosStartLat, cosAngDist - Math.sin(startLat) * Math.sin(lat2));
        if (result == null || result.length != 2) {
            result = new double[]{lat2, lon2};
        }
        DistanceUtils.normLng(result);
        DistanceUtils.normLat(result);
        return result;
    }

    public static void normLat(double[] latLng) {
        if (latLng[0] > 1.5707963267948966) {
            latLng[0] = 1.5707963267948966 - (latLng[0] - 1.5707963267948966);
            latLng[1] = latLng[1] < 0.0 ? latLng[1] + Math.PI : latLng[1] - Math.PI;
        } else if (latLng[0] < -1.5707963267948966) {
            latLng[0] = -1.5707963267948966 - (latLng[0] + 1.5707963267948966);
            latLng[1] = latLng[1] < 0.0 ? latLng[1] + Math.PI : latLng[1] - Math.PI;
        }
    }

    public static void normLng(double[] latLng) {
        if (latLng[1] > Math.PI) {
            latLng[1] = -1.0 * (Math.PI - (latLng[1] - Math.PI));
        } else if (latLng[1] < -Math.PI) {
            latLng[1] = latLng[1] + Math.PI + Math.PI;
        }
    }

    public static double squaredEuclideanDistance(double[] vec1, double[] vec2) {
        double result = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            double v = vec1[i] - vec2[i];
            result += v * v;
        }
        return result;
    }

    public static double haversine(double x1, double y1, double x2, double y2, double radius) {
        double result = 0.0;
        if (x1 != x2 || y1 != y2) {
            double diffX = x1 - x2;
            double diffY = y1 - y2;
            double hsinX = Math.sin(diffX * 0.5);
            double hsinY = Math.sin(diffY * 0.5);
            double h = hsinX * hsinX + Math.cos(x1) * Math.cos(x2) * hsinY * hsinY;
            result = radius * 2.0 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
        }
        return result;
    }

    public static String[] parsePoint(String[] out, String externalVal, int dimension) throws InvalidGeoException {
        int i;
        int idx;
        if (out == null || out.length != dimension) {
            out = new String[dimension];
        }
        int end = idx = externalVal.indexOf(44);
        int start = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = externalVal.trim();
            i = 1;
        } else if (idx > 0) {
            for (i = 0; i < dimension; ++i) {
                while (start < end && externalVal.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && externalVal.charAt(end - 1) == ' ') {
                    --end;
                }
                if (start == end) break;
                out[i] = externalVal.substring(start, end);
                start = idx + 1;
                idx = end = externalVal.indexOf(44, start);
                if (end != -1) continue;
                end = externalVal.length();
            }
        }
        if (i != dimension) {
            throw new InvalidGeoException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i + " values specified");
        }
        return out;
    }

    public static double[] parsePointDouble(double[] out, String externalVal, int dimension) throws InvalidGeoException {
        int i;
        int idx;
        if (out == null || out.length != dimension) {
            out = new double[dimension];
        }
        int end = idx = externalVal.indexOf(44);
        int start = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = Double.parseDouble(externalVal.trim());
            i = 1;
        } else if (idx > 0) {
            for (i = 0; i < dimension; ++i) {
                while (start < end && externalVal.charAt(start) == ' ') {
                    ++start;
                }
                while (end > start && externalVal.charAt(end - 1) == ' ') {
                    --end;
                }
                if (start == end) break;
                out[i] = Double.parseDouble(externalVal.substring(start, end));
                start = idx + 1;
                idx = end = externalVal.indexOf(44, start);
                if (end != -1) continue;
                end = externalVal.length();
            }
        }
        if (i != dimension) {
            throw new InvalidGeoException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i + " values specified");
        }
        return out;
    }

    public static final double[] parseLatitudeLongitude(String latLonStr) throws InvalidGeoException {
        return DistanceUtils.parseLatitudeLongitude(null, latLonStr);
    }

    public static final double[] parseLatitudeLongitude(double[] latLon, String latLonStr) throws InvalidGeoException {
        double[] toks;
        if (latLon == null) {
            latLon = new double[2];
        }
        if ((toks = DistanceUtils.parsePointDouble(null, latLonStr, 2))[0] < -90.0 || toks[0] > 90.0) {
            throw new InvalidGeoException("Invalid latitude: latitudes are range -90 to 90: provided lat: [" + toks[0] + "]");
        }
        latLon[0] = toks[0];
        if (toks[1] < -180.0 || toks[1] > 180.0) {
            throw new InvalidGeoException("Invalid longitude: longitudes are range -180 to 180: provided lon: [" + toks[1] + "]");
        }
        latLon[1] = toks[1];
        return latLon;
    }
}

