/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.geometry.shape.Rectangle;
import org.apache.lucene.spatial.tier.CartesianShapeFilter;
import org.apache.lucene.spatial.tier.DistanceUtils;
import org.apache.lucene.spatial.tier.Shape;
import org.apache.lucene.spatial.tier.projections.CartesianTierPlotter;
import org.apache.lucene.spatial.tier.projections.IProjector;
import org.apache.lucene.spatial.tier.projections.SinusoidalProjector;

public class CartesianPolyFilterBuilder {
    public static final double MILES_FLOOR = 1.0;
    private IProjector projector = new SinusoidalProjector();
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final String tierPrefix;

    public CartesianPolyFilterBuilder(String tierPrefix) {
        this.tierPrefix = tierPrefix;
    }

    public Shape getBoxShape(double latitude, double longitude, double miles) {
        if (miles < 1.0) {
            miles = 1.0;
        }
        Rectangle box = DistanceUtils.getInstance().getBoundary(latitude, longitude, miles);
        double latY = box.getMaxPoint().getY();
        double latX = box.getMinPoint().getY();
        double longY = box.getMaxPoint().getX();
        double longX = box.getMinPoint().getX();
        CartesianTierPlotter ctp = new CartesianTierPlotter(2, this.projector, this.tierPrefix);
        int bestFit = ctp.bestFit(miles);
        this.log.info("Best Fit is : " + bestFit);
        ctp = new CartesianTierPlotter(bestFit, this.projector, this.tierPrefix);
        Shape shape = new Shape(ctp.getTierFieldName());
        double beginAt = ctp.getTierBoxId(latX, longX);
        double endAt = ctp.getTierBoxId(latY, longY);
        double tierVert = ctp.getTierVerticalPosDivider();
        this.log.fine(" | " + beginAt + " | " + endAt);
        double startX = beginAt - beginAt % 1.0;
        double startY = beginAt - startX;
        double endX = endAt - endAt % 1.0;
        double endY = endAt - endX;
        int scale = (int)Math.log10(tierVert);
        endY = new BigDecimal(endY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        startY = new BigDecimal(startY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("scale " + scale + " startX " + startX + " endX " + endX + " startY " + startY + " endY " + endY + " tierVert " + tierVert);
        }
        double xInc = 1.0 / tierVert;
        xInc = new BigDecimal(xInc).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
        while (startX <= endX) {
            double itY = startY;
            while (itY <= endY) {
                double boxId = startX + itY;
                shape.addBox(boxId);
                itY += xInc;
                itY = new BigDecimal(itY).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
            }
            startX += 1.0;
        }
        return shape;
    }

    public Filter getBoundingArea(double latitude, double longitude, double miles) {
        Shape shape = this.getBoxShape(latitude, longitude, miles);
        return new CartesianShapeFilter(shape, shape.getTierId());
    }
}

