/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.WordSegmenter;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class WordTokenFilter
extends TokenFilter {
    private WordSegmenter wordSegmenter = new WordSegmenter();
    private Iterator tokenIter;
    private List tokenBuffer;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public WordTokenFilter(TokenStream in) {
        super(in);
    }

    public boolean incrementToken() throws IOException {
        if (this.tokenIter == null || !this.tokenIter.hasNext()) {
            if (this.input.incrementToken()) {
                this.tokenBuffer = this.wordSegmenter.segmentSentence(this.termAtt.term(), this.offsetAtt.startOffset());
                this.tokenIter = this.tokenBuffer.iterator();
                if (!this.tokenIter.hasNext()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.clearAttributes();
        SegToken nextWord = (SegToken)this.tokenIter.next();
        this.termAtt.setTermBuffer(nextWord.charArray, 0, nextWord.charArray.length);
        this.offsetAtt.setOffset(nextWord.startOffset, nextWord.endOffset);
        this.typeAtt.setType("word");
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenIter = null;
    }
}

