/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.PrimaryNode;

class PreCopyMergedSegmentWarmer
implements IndexWriter.IndexReaderWarmer {
    private final PrimaryNode primary;

    public PreCopyMergedSegmentWarmer(PrimaryNode primary) {
        this.primary = primary;
    }

    public void warm(LeafReader reader) throws IOException {
        long startNS = System.nanoTime();
        SegmentCommitInfo info = ((SegmentReader)reader).getSegmentInfo();
        HashMap<String, FileMetaData> filesMetaData = new HashMap<String, FileMetaData>();
        for (String fileName : info.files()) {
            FileMetaData metaData = this.primary.readLocalFileMetaData(fileName);
            assert (metaData != null);
            assert (!filesMetaData.containsKey(fileName));
            filesMetaData.put(fileName, metaData);
        }
        this.primary.preCopyMergedSegmentFiles(info, filesMetaData);
        this.primary.message(String.format(Locale.ROOT, "top: done warm merge " + String.valueOf(info) + ": took %.3f sec, %.1f MB", (double)(System.nanoTime() - startNS) / (double)TimeUnit.SECONDS.toNanos(1L), (double)info.sizeInBytes() / 1024.0 / 1024.0));
        this.primary.finishedMergedFiles.addAll(filesMetaData.keySet());
    }
}

