/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.replicator.Replicator;
import org.apache.lucene.replicator.RevisionFile;
import org.apache.lucene.replicator.SessionToken;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.ThreadInterruptedException;

public class ReplicationClient
implements Closeable {
    public static final String INFO_STREAM_COMPONENT = "ReplicationThread";
    private final Replicator replicator;
    private final ReplicationHandler handler;
    private final SourceDirectoryFactory factory;
    private final byte[] copyBuffer = new byte[16384];
    private final Lock updateLock = new ReentrantLock();
    private volatile ReplicationThread updateThread;
    private volatile boolean closed = false;
    private volatile InfoStream infoStream = InfoStream.getDefault();

    public ReplicationClient(Replicator replicator, ReplicationHandler handler, SourceDirectoryFactory factory) {
        this.replicator = replicator;
        this.handler = handler;
        this.factory = factory;
    }

    private void copyBytes(IndexOutput out, InputStream in) throws IOException {
        int numBytes;
        while ((numBytes = in.read(this.copyBuffer)) > 0) {
            out.writeBytes(this.copyBuffer, 0, numBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() throws IOException {
        SessionToken session = null;
        HashMap<String, Directory> sourceDirectory = new HashMap<String, Directory>();
        HashMap<String, List<String>> copiedFiles = new HashMap<String, List<String>>();
        boolean notify = false;
        try {
            String version = this.handler.currentVersion();
            session = this.replicator.checkForUpdate(version);
            if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
                this.infoStream.message(INFO_STREAM_COMPONENT, "doUpdate(): handlerVersion=" + version + " session=" + session);
            }
            if (session == null) {
                return;
            }
            Map<String, List<RevisionFile>> requiredFiles = this.requiredFiles(session.sourceFiles);
            if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
                this.infoStream.message(INFO_STREAM_COMPONENT, "doUpdate(): requiredFiles=" + requiredFiles);
            }
            for (Map.Entry<String, List<RevisionFile>> e : requiredFiles.entrySet()) {
                String source = e.getKey();
                Directory dir = this.factory.getDirectory(session.id, source);
                sourceDirectory.put(source, dir);
                ArrayList<String> cpFiles = new ArrayList<String>();
                copiedFiles.put(source, cpFiles);
                for (RevisionFile file : e.getValue()) {
                    if (this.closed) {
                        if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
                            this.infoStream.message(INFO_STREAM_COMPONENT, "doUpdate(): detected client was closed); abort file copy");
                        }
                        return;
                    }
                    InputStream in = null;
                    IndexOutput out = null;
                    try {
                        in = this.replicator.obtainFile(session.id, source, file.fileName);
                        out = dir.createOutput(file.fileName, IOContext.DEFAULT);
                        this.copyBytes(out, in);
                        cpFiles.add(file.fileName);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close((Closeable[])new Closeable[]{in, out});
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{in, out});
                }
            }
            notify = true;
        }
        finally {
            if (session != null) {
                try {
                    this.replicator.release(session.id);
                }
                finally {
                    if (!notify) {
                        IOUtils.close(sourceDirectory.values());
                        this.factory.cleanupSession(session.id);
                    }
                }
            }
        }
        try {
            if (notify && !this.closed) {
                this.handler.revisionReady(session.version, session.sourceFiles, copiedFiles, sourceDirectory);
            }
        }
        finally {
            IOUtils.close(sourceDirectory.values());
            if (session != null) {
                this.factory.cleanupSession(session.id);
            }
        }
    }

    protected final void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("this update client has already been closed");
        }
    }

    protected void handleUpdateException(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
            this.infoStream.message(INFO_STREAM_COMPONENT, "an error occurred during revision update: " + sw.toString());
        }
    }

    protected Map<String, List<RevisionFile>> requiredFiles(Map<String, List<RevisionFile>> newRevisionFiles) {
        Map<String, List<RevisionFile>> handlerRevisionFiles = this.handler.currentRevisionFiles();
        if (handlerRevisionFiles == null) {
            return newRevisionFiles;
        }
        HashMap<String, List<RevisionFile>> requiredFiles = new HashMap<String, List<RevisionFile>>();
        for (Map.Entry<String, List<RevisionFile>> e : handlerRevisionFiles.entrySet()) {
            HashSet<String> handlerFiles = new HashSet<String>();
            for (RevisionFile file : e.getValue()) {
                handlerFiles.add(file.fileName);
            }
            ArrayList<RevisionFile> res = new ArrayList<RevisionFile>();
            String source = e.getKey();
            assert (newRevisionFiles.containsKey(source)) : "source not found in newRevisionFiles: " + newRevisionFiles;
            for (RevisionFile file : newRevisionFiles.get(source)) {
                if (handlerFiles.contains(file.fileName)) continue;
                res.add(file);
            }
            requiredFiles.put(source, res);
        }
        return requiredFiles;
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.stopUpdateThread();
            this.closed = true;
        }
    }

    public synchronized void startUpdateThread(long intervalMillis, String threadName) {
        this.ensureOpen();
        if (this.updateThread != null && this.updateThread.isAlive()) {
            throw new IllegalStateException("cannot start an update thread when one is running, must first call 'stopUpdateThread()'");
        }
        threadName = threadName == null ? INFO_STREAM_COMPONENT : "ReplicationThread-" + (String)threadName;
        this.updateThread = new ReplicationThread(intervalMillis);
        this.updateThread.setName((String)threadName);
        this.updateThread.start();
        assert (this.updateThread.isAlive()) : "updateThread started but not alive?";
    }

    public synchronized void stopUpdateThread() {
        if (this.updateThread != null) {
            this.updateThread.stop.countDown();
            try {
                this.updateThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ThreadInterruptedException(e);
            }
            this.updateThread = null;
        }
    }

    public synchronized boolean isUpdateThreadAlive() {
        return this.updateThread != null && this.updateThread.isAlive();
    }

    public String toString() {
        Object res = "ReplicationClient";
        if (this.updateThread != null) {
            res = (String)res + " (" + this.updateThread.getName() + ")";
        }
        return res;
    }

    public void updateNow() throws IOException {
        this.ensureOpen();
        this.updateLock.lock();
        try {
            this.doUpdate();
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void setInfoStream(InfoStream infoStream) {
        if (infoStream == null) {
            infoStream = InfoStream.NO_OUTPUT;
        }
        this.infoStream = infoStream;
    }

    public static interface SourceDirectoryFactory {
        public void cleanupSession(String var1) throws IOException;

        public Directory getDirectory(String var1, String var2) throws IOException;
    }

    public static interface ReplicationHandler {
        public Map<String, List<RevisionFile>> currentRevisionFiles();

        public String currentVersion();

        public void revisionReady(String var1, Map<String, List<RevisionFile>> var2, Map<String, List<String>> var3, Map<String, Directory> var4) throws IOException;
    }

    private class ReplicationThread
    extends Thread {
        private final long interval;
        final CountDownLatch stop = new CountDownLatch(1);

        public ReplicationThread(long interval) {
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                long timeout;
                long time = System.currentTimeMillis();
                ReplicationClient.this.updateLock.lock();
                try {
                    ReplicationClient.this.doUpdate();
                }
                catch (Throwable t) {
                    ReplicationClient.this.handleUpdateException(t);
                }
                finally {
                    ReplicationClient.this.updateLock.unlock();
                }
                if ((timeout = this.interval - (time = System.currentTimeMillis() - time)) <= 0L) continue;
                if (this.stop.await(timeout, TimeUnit.MILLISECONDS)) return;
                continue;
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ThreadInterruptedException(e);
            }
        }
    }
}

