/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.replicator.nrt.CopyJob;
import org.apache.lucene.replicator.nrt.CopyState;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.replicator.nrt.NodeCommunicationException;
import org.apache.lucene.replicator.nrt.ReplicaFileDeleter;
import org.apache.lucene.replicator.nrt.SegmentInfosSearcherManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class ReplicaNode
extends Node {
    ReplicaFileDeleter deleter;
    private final Collection<String> lastCommitFiles = new HashSet<String>();
    protected final Collection<String> lastNRTFiles = new HashSet<String>();
    protected final Set<CopyJob> mergeCopyJobs = Collections.synchronizedSet(new HashSet());
    protected CopyJob curNRTCopy;
    private final Lock writeFileLock;
    final Set<String> pendingMergeFiles = Collections.synchronizedSet(new HashSet());
    protected long lastPrimaryGen;
    final Object commitLock = new Object();
    private ConcurrentMap<String, Boolean> copying = new ConcurrentHashMap<String, Boolean>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReplicaNode(int id, Directory dir, SearcherFactory searcherFactory, PrintStream printStream) throws IOException {
        super(id, dir, searcherFactory, printStream);
        if (!dir.getPendingDeletions().isEmpty()) {
            throw new IllegalArgumentException("Directory " + dir + " still has pending deleted files; cannot initialize IndexWriter");
        }
        boolean success = false;
        try {
            this.message("top: init replica dir=" + dir);
            this.writeFileLock = dir.obtainLock("write.lock");
            this.state = "init";
            this.deleter = new ReplicaFileDeleter(this, dir);
            return;
        }
        catch (Throwable t) {
            try {
                this.message("exc on init:");
                t.printStackTrace(printStream);
                throw t;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
                throw throwable;
            }
        }
    }

    protected synchronized void start(long curPrimaryGen) throws IOException {
        if (!this.state.equals("init")) {
            throw new IllegalStateException("already started");
        }
        this.message("top: now start");
        try {
            boolean doCommit;
            long myPrimaryGen;
            SegmentInfos infos;
            String segmentsFileName = SegmentInfos.getLastCommitSegmentsFileName((Directory)this.dir);
            long maxPendingGen = -1L;
            for (String fileName : this.dir.listAll()) {
                long gen;
                if (!fileName.startsWith("pending_segments") || (gen = Long.parseLong(fileName.substring("pending_segments".length() + 1), 36)) <= maxPendingGen) continue;
                maxPendingGen = gen;
            }
            if (segmentsFileName == null) {
                infos = new SegmentInfos(Version.LATEST.major);
                this.message("top: init: no segments in index");
            } else {
                this.message("top: init: read existing segments commit " + segmentsFileName);
                infos = SegmentInfos.readCommit((Directory)this.dir, (String)segmentsFileName);
                this.message("top: init: segments: " + infos.toString() + " version=" + infos.getVersion());
                Collection indexFiles = infos.files(false);
                this.lastCommitFiles.add(segmentsFileName);
                this.lastCommitFiles.addAll(indexFiles);
                this.deleter.incRef(this.lastCommitFiles);
                this.lastNRTFiles.addAll(indexFiles);
                this.deleter.incRef(this.lastNRTFiles);
                this.message("top: commitFiles=" + this.lastCommitFiles);
                this.message("top: nrtFiles=" + this.lastNRTFiles);
            }
            this.message("top: delete unknown files on init: all files=" + Arrays.toString(this.dir.listAll()));
            this.deleter.deleteUnknownFiles(segmentsFileName);
            this.message("top: done delete unknown files on init: all files=" + Arrays.toString(this.dir.listAll()));
            String s = (String)infos.getUserData().get(PRIMARY_GEN_KEY);
            if (s == null) {
                assert (infos.size() == 0);
                myPrimaryGen = -1L;
            } else {
                myPrimaryGen = Long.parseLong(s);
            }
            this.message("top: myPrimaryGen=" + myPrimaryGen);
            if (infos.size() > 0 && myPrimaryGen != -1L && myPrimaryGen != curPrimaryGen) {
                assert (myPrimaryGen < curPrimaryGen);
                long initSyncStartNS = System.nanoTime();
                this.message("top: init: primary changed while we were down myPrimaryGen=" + myPrimaryGen + " vs curPrimaryGen=" + curPrimaryGen + "; sync now before mgr init");
                CopyJob job = null;
                this.message("top: now delete starting commit point " + segmentsFileName);
                assert (this.deleter.getRefCount(segmentsFileName) == 1);
                this.deleter.decRef(Collections.singleton(segmentsFileName));
                if (!this.dir.getPendingDeletions().isEmpty()) {
                    throw new RuntimeException("replica cannot start: existing segments file=" + segmentsFileName + " must be removed in order to start, but the file delete failed");
                }
                boolean didRemove = this.lastCommitFiles.remove(segmentsFileName);
                assert (didRemove);
                while (true) {
                    job = this.newCopyJob("sync on startup replica=" + this.name() + " myVersion=" + infos.getVersion(), null, null, true, null);
                    job.start();
                    this.message("top: init: sync sis.version=" + job.getCopyState().version);
                    try {
                        job.runBlocking();
                        job.finish();
                    }
                    catch (IOException ioe) {
                        job.cancel("startup failed", ioe);
                        if (ioe.getMessage().contains("checksum mismatch after file copy")) {
                            this.message("top: failed to copy: " + ioe + "; retrying");
                            continue;
                        }
                        throw ioe;
                    }
                    break;
                }
                this.lastPrimaryGen = job.getCopyState().primaryGen;
                SegmentInfos syncInfos = SegmentInfos.readCommit((Directory)this.dir, (ChecksumIndexInput)this.toIndexInput(job.getCopyState().infosBytes), (long)job.getCopyState().gen);
                syncInfos.updateGeneration(infos);
                infos = syncInfos;
                assert (infos.getVersion() == job.getCopyState().version);
                this.message("  version=" + infos.getVersion() + " segments=" + infos.toString());
                this.message("top: init: incRef nrtFiles=" + job.getFileNames());
                this.deleter.incRef(job.getFileNames());
                this.message("top: init: decRef lastNRTFiles=" + this.lastNRTFiles);
                this.deleter.decRef(this.lastNRTFiles);
                this.lastNRTFiles.clear();
                this.lastNRTFiles.addAll(job.getFileNames());
                this.message("top: init: set lastNRTFiles=" + this.lastNRTFiles);
                this.lastFileMetaData = job.getCopyState().files;
                this.message(String.format(Locale.ROOT, "top: %d: start: done sync: took %.3fs for %s, opened NRT reader version=%d", this.id, (double)(System.nanoTime() - initSyncStartNS) / 1.0E9, ReplicaNode.bytesToString(job.getTotalBytesCopied()), job.getCopyState().version));
                doCommit = true;
            } else {
                doCommit = false;
                this.lastPrimaryGen = curPrimaryGen;
                this.message("top: same primary as before");
            }
            if (infos.getGeneration() < maxPendingGen) {
                this.message("top: move infos generation from " + infos.getGeneration() + " to " + maxPendingGen);
                infos.setNextWriteGeneration(maxPendingGen);
            }
            this.sendNewReplica();
            this.mgr = new SegmentInfosSearcherManager(this.dir, this, infos, this.searcherFactory);
            if (doCommit) {
                this.commit();
            }
            this.message("top: done start");
            this.state = "idle";
        }
        catch (Throwable t) {
            if (!Objects.toString(t.getMessage()).startsWith("replica cannot start")) {
                this.message("exc on start:");
                t.printStackTrace(this.printStream);
            } else {
                this.dir.close();
            }
            throw IOUtils.rethrowAlways((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            Collection indexFiles;
            SegmentInfos infos;
            ReplicaNode replicaNode = this;
            synchronized (replicaNode) {
                infos = ((SegmentInfosSearcherManager)this.mgr).getCurrentInfos();
                indexFiles = infos.files(false);
                this.deleter.incRef(indexFiles);
            }
            this.message("top: commit primaryGen=" + this.lastPrimaryGen + " infos=" + infos.toString() + " files=" + indexFiles);
            this.dir.sync(indexFiles);
            HashMap<String, String> commitData = new HashMap<String, String>();
            commitData.put(PRIMARY_GEN_KEY, Long.toString(this.lastPrimaryGen));
            commitData.put(VERSION_KEY, Long.toString(this.getCurrentSearchingVersion()));
            infos.setUserData(commitData, false);
            infos.commit(this.dir);
            ((SegmentInfosSearcherManager)this.mgr).getCurrentInfos().updateGeneration(infos);
            String segmentsFileName = infos.getSegmentsFileName();
            this.message("top: commit wrote segments file " + segmentsFileName + " version=" + infos.getVersion() + " sis=" + infos.toString() + " commitData=" + commitData);
            this.deleter.incRef(Collections.singletonList(segmentsFileName));
            this.message("top: commit decRef lastCommitFiles=" + this.lastCommitFiles);
            this.deleter.decRef(this.lastCommitFiles);
            this.lastCommitFiles.clear();
            this.lastCommitFiles.addAll(indexFiles);
            this.lastCommitFiles.add(segmentsFileName);
            this.message("top: commit version=" + infos.getVersion() + " files now " + this.lastCommitFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishNRTCopy(CopyJob job, long startNS) throws IOException {
        int markerCount;
        CopyState copyState = job.getCopyState();
        this.message("top: finishNRTCopy: version=" + copyState.version + (job.getFailed() ? " FAILED" : "") + " job=" + job);
        ReplicaNode replicaNode = this;
        synchronized (replicaNode) {
            if ("syncing".equals(this.state)) {
                this.state = "idle";
            }
            if (this.curNRTCopy == job) {
                this.message("top: now clear curNRTCopy; job=" + job);
                this.curNRTCopy = null;
            } else {
                assert (job.getFailed());
                this.message("top: skip clear curNRTCopy: we were cancelled; job=" + job);
            }
            if (job.getFailed()) {
                return;
            }
            job.finish();
            SegmentInfos infos = SegmentInfos.readCommit((Directory)this.dir, (ChecksumIndexInput)this.toIndexInput(copyState.infosBytes), (long)copyState.gen);
            assert (infos.getVersion() == copyState.version);
            this.message("  version=" + infos.getVersion() + " segments=" + infos.toString());
            ((SegmentInfosSearcherManager)this.mgr).setCurrentInfos(infos);
            Set<String> newFiles = copyState.files.keySet();
            this.message("top: incRef newNRTFiles=" + newFiles);
            this.deleter.incRef(newFiles);
            this.pendingMergeFiles.removeAll(newFiles);
            this.message("top: after remove from pending merges pendingMergeFiles=" + this.pendingMergeFiles);
            this.message("top: decRef lastNRTFiles=" + this.lastNRTFiles);
            this.deleter.decRef(this.lastNRTFiles);
            this.lastNRTFiles.clear();
            this.lastNRTFiles.addAll(newFiles);
            this.message("top: set lastNRTFiles=" + this.lastNRTFiles);
            if (!copyState.completedMergeFiles.isEmpty()) {
                this.message("now remove-if-not-ref'd completed merge files: " + copyState.completedMergeFiles);
                for (String fileName : copyState.completedMergeFiles) {
                    if (!this.pendingMergeFiles.contains(fileName)) continue;
                    this.pendingMergeFiles.remove(fileName);
                    this.deleter.deleteIfNoRef(fileName);
                }
            }
            this.lastFileMetaData = copyState.files;
        }
        IndexSearcher s = (IndexSearcher)this.mgr.acquire();
        try {
            markerCount = s.count((Query)new TermQuery(new Term("marker", "marker")));
        }
        finally {
            this.mgr.release((Object)s);
        }
        this.message(String.format(Locale.ROOT, "top: done sync: took %.3fs for %s, opened NRT reader version=%d markerCount=%d", (double)(System.nanoTime() - startNS) / 1.0E9, ReplicaNode.bytesToString(job.getTotalBytesCopied()), copyState.version, markerCount));
    }

    private ChecksumIndexInput toIndexInput(byte[] input) {
        return new BufferedChecksumIndexInput((IndexInput)new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(ByteBuffer.wrap(input))), "SegmentInfos"));
    }

    protected abstract CopyJob newCopyJob(String var1, Map<String, FileMetaData> var2, Map<String, FileMetaData> var3, boolean var4, CopyJob.OnceDone var5) throws IOException;

    protected abstract void launch(CopyJob var1);

    protected abstract void sendNewReplica() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CopyJob newNRTPoint(long newPrimaryGen, long version) throws IOException {
        if (this.isClosed()) {
            throw new AlreadyClosedException("this replica is closed: state=" + this.state);
        }
        this.maybeNewPrimary(newPrimaryGen);
        assert (this.mgr != null);
        if ("idle".equals(this.state)) {
            this.state = "syncing";
        }
        long curVersion = this.getCurrentSearchingVersion();
        this.message("top: start sync sis.version=" + version);
        if (version == curVersion) {
            this.message("top: new NRT point has same version as current; skipping");
            return null;
        }
        if (version < curVersion) {
            this.message("top: new NRT point (version=" + version + ") is older than current (version=" + curVersion + "); skipping");
            return null;
        }
        final long startNS = System.nanoTime();
        this.message("top: newNRTPoint");
        CopyJob job = null;
        try {
            job = this.newCopyJob("NRT point sync version=" + version, null, this.lastFileMetaData, true, new CopyJob.OnceDone(){

                @Override
                public void run(CopyJob job) {
                    try {
                        ReplicaNode.this.finishNRTCopy(job, startNS);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            });
        }
        catch (NodeCommunicationException nce) {
            this.message("top: ignoring communication exception creating CopyJob: " + nce);
            if (this.state.equals("syncing")) {
                this.state = "idle";
            }
            return null;
        }
        assert (newPrimaryGen == job.getCopyState().primaryGen);
        Set<String> newNRTFiles = job.getFileNames();
        this.message("top: newNRTPoint: job files=" + newNRTFiles);
        if (this.curNRTCopy != null) {
            job.transferAndCancel(this.curNRTCopy);
            assert (this.curNRTCopy.getFailed());
        }
        this.curNRTCopy = job;
        for (String fileName : this.curNRTCopy.getFileNamesToCopy()) {
            assert (!this.lastCommitFiles.contains(fileName)) : "fileName=" + fileName + " is in lastCommitFiles and is being copied?";
            Set<CopyJob> set = this.mergeCopyJobs;
            synchronized (set) {
                for (CopyJob mergeJob : this.mergeCopyJobs) {
                    if (!mergeJob.getFileNames().contains(fileName)) continue;
                    this.message("top: now cancel merge copy job=" + mergeJob + ": file " + fileName + " is now being copied via NRT point");
                    mergeJob.cancel("newNRTPoint is copying over the same file", null);
                }
            }
        }
        try {
            job.start();
        }
        catch (NodeCommunicationException nce) {
            this.message("top: ignoring exception starting CopyJob: " + nce);
            nce.printStackTrace(this.printStream);
            if (this.state.equals("syncing")) {
                this.state = "idle";
            }
            return null;
        }
        this.launch(this.curNRTCopy);
        return this.curNRTCopy;
    }

    public synchronized boolean isCopying() {
        return this.curNRTCopy != null;
    }

    @Override
    public boolean isClosed() {
        return "closed".equals(this.state) || "closing".equals(this.state) || "crashing".equals(this.state) || "crashed".equals(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.message("top: now close");
        ReplicaNode replicaNode = this;
        synchronized (replicaNode) {
            this.state = "closing";
            if (this.curNRTCopy != null) {
                this.curNRTCopy.cancel("closing", null);
            }
        }
        replicaNode = this;
        synchronized (replicaNode) {
            this.message("top: close mgr");
            this.mgr.close();
            this.message("top: decRef lastNRTFiles=" + this.lastNRTFiles);
            this.deleter.decRef(this.lastNRTFiles);
            this.lastNRTFiles.clear();
            this.lastCommitFiles.clear();
            this.message("top: delete if no ref pendingMergeFiles=" + this.pendingMergeFiles);
            for (String fileName : this.pendingMergeFiles) {
                this.deleter.deleteIfNoRef(fileName);
            }
            this.pendingMergeFiles.clear();
            this.message("top: close dir");
            IOUtils.close((Closeable[])new Closeable[]{this.writeFileLock, this.dir});
        }
        this.message("top: done close");
        this.state = "closed";
    }

    protected synchronized void maybeNewPrimary(long newPrimaryGen) throws IOException {
        if (newPrimaryGen != this.lastPrimaryGen) {
            this.message("top: now change lastPrimaryGen from " + this.lastPrimaryGen + " to " + newPrimaryGen + " pendingMergeFiles=" + this.pendingMergeFiles);
            this.message("top: delete if no ref pendingMergeFiles=" + this.pendingMergeFiles);
            for (String fileName : this.pendingMergeFiles) {
                this.deleter.deleteIfNoRef(fileName);
            }
            assert (newPrimaryGen > this.lastPrimaryGen) : "newPrimaryGen=" + newPrimaryGen + " vs lastPrimaryGen=" + this.lastPrimaryGen;
            this.lastPrimaryGen = newPrimaryGen;
            this.pendingMergeFiles.clear();
        } else {
            this.message("top: keep current lastPrimaryGen=" + this.lastPrimaryGen);
        }
    }

    protected synchronized CopyJob launchPreCopyMerge(final AtomicBoolean finished, long newPrimaryGen, Map<String, FileMetaData> files) throws IOException {
        this.maybeNewPrimary(newPrimaryGen);
        final long primaryGenStart = this.lastPrimaryGen;
        final Set<String> fileNames = files.keySet();
        this.message("now pre-copy warm merge files=" + fileNames + " primaryGen=" + newPrimaryGen);
        for (String fileName : fileNames) {
            assert (!this.pendingMergeFiles.contains(fileName)) : "file \"" + fileName + "\" is already being warmed!";
            assert (!this.lastNRTFiles.contains(fileName)) : "file \"" + fileName + "\" is already NRT visible!";
        }
        CopyJob job = this.newCopyJob("warm merge on " + this.name() + " filesNames=" + fileNames, files, null, false, new CopyJob.OnceDone(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(CopyJob job) throws IOException {
                ReplicaNode.this.mergeCopyJobs.remove(job);
                ReplicaNode.this.message("done warming merge " + fileNames + " failed?=" + job.getFailed());
                2 var2_2 = this;
                synchronized (var2_2) {
                    if (!job.getFailed()) {
                        if (ReplicaNode.this.lastPrimaryGen != primaryGenStart) {
                            ReplicaNode.this.message("merge pre copy finished but primary has changed; cancelling job files=" + fileNames);
                            job.cancel("primary changed during merge copy", null);
                        } else {
                            boolean abort = false;
                            for (String fileName : fileNames) {
                                if (ReplicaNode.this.lastNRTFiles.contains(fileName)) {
                                    ReplicaNode.this.message("abort merge finish: file " + fileName + " is referenced by last NRT point");
                                    abort = true;
                                }
                                if (!ReplicaNode.this.lastCommitFiles.contains(fileName)) continue;
                                ReplicaNode.this.message("abort merge finish: file " + fileName + " is referenced by last commit point");
                                abort = true;
                            }
                            if (abort) {
                                job.cancel("merged segment was separately copied via NRT point", null);
                            } else {
                                job.finish();
                                ReplicaNode.this.message("merge pre copy finished files=" + fileNames);
                                for (String fileName : fileNames) {
                                    assert (!ReplicaNode.this.pendingMergeFiles.contains(fileName)) : "file \"" + fileName + "\" is already in pendingMergeFiles";
                                    ReplicaNode.this.message("add file " + fileName + " to pendingMergeFiles");
                                    ReplicaNode.this.pendingMergeFiles.add(fileName);
                                }
                            }
                        }
                    } else {
                        ReplicaNode.this.message("merge copy finished with failure");
                    }
                }
                finished.set(true);
            }
        });
        job.start();
        assert (job.getFileNamesToCopy().size() == files.size());
        this.mergeCopyJobs.add(job);
        this.launch(job);
        return job;
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext ioContext) throws IOException {
        return this.dir.createTempOutput(prefix, suffix, IOContext.DEFAULT);
    }

    public List<Map.Entry<String, FileMetaData>> getFilesToCopy(Map<String, FileMetaData> files) throws IOException {
        ArrayList<Map.Entry<String, FileMetaData>> toCopy = new ArrayList<Map.Entry<String, FileMetaData>>();
        for (Map.Entry<String, FileMetaData> ent : files.entrySet()) {
            FileMetaData fileMetaData;
            String fileName = ent.getKey();
            if (this.fileIsIdentical(fileName, fileMetaData = ent.getValue())) continue;
            toCopy.add(ent);
        }
        return toCopy;
    }

    private boolean fileIsIdentical(String fileName, FileMetaData srcMetaData) throws IOException {
        FileMetaData destMetaData = this.readLocalFileMetaData(fileName);
        if (destMetaData == null) {
            return false;
        }
        if (!Arrays.equals(destMetaData.header, srcMetaData.header) || !Arrays.equals(destMetaData.footer, srcMetaData.footer)) {
            if (Node.VERBOSE_FILES) {
                this.message("file " + fileName + ": will copy [header/footer is different]");
            }
            return false;
        }
        return true;
    }

    public void startCopyFile(String name) {
        if (this.copying.putIfAbsent(name, Boolean.TRUE) != null) {
            throw new IllegalStateException("file " + name + " is being copied in two places!");
        }
    }

    public void finishCopyFile(String name) {
        if (this.copying.remove(name) == null) {
            throw new IllegalStateException("file " + name + " was not actually being copied?");
        }
    }
}

