/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.replicator.Replicator;
import org.apache.lucene.replicator.SessionToken;
import org.apache.lucene.util.SuppressForbidden;

public class ReplicationService {
    public static final String REPLICATION_CONTEXT = "/replicate";
    public static final String REPLICATE_VERSION_PARAM = "version";
    public static final String REPLICATE_SESSION_ID_PARAM = "sessionid";
    public static final String REPLICATE_SOURCE_PARAM = "source";
    public static final String REPLICATE_FILENAME_PARAM = "filename";
    private static final int SHARD_IDX = 0;
    private static final int ACTION_IDX = 1;
    private final Map<String, Replicator> replicators;

    public ReplicationService(Map<String, Replicator> replicators) {
        this.replicators = replicators;
    }

    private String[] getPathElements(HttpServletRequest req) {
        int actionLen;
        String path = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        int startIdx = actionLen = REPLICATION_CONTEXT.length();
        if (path.length() > actionLen && path.charAt(actionLen) == '/') {
            ++startIdx;
        }
        StringTokenizer stok = new StringTokenizer(path.substring(startIdx), "/");
        ArrayList<String> elements = new ArrayList<String>();
        while (stok.hasMoreTokens()) {
            elements.add(stok.nextToken());
        }
        return elements.toArray(new String[0]);
    }

    private static String extractRequestParam(HttpServletRequest req, String paramName) throws ServletException {
        String param = req.getParameter(paramName);
        if (param == null) {
            throw new ServletException("Missing mandatory parameter: " + paramName);
        }
        return param;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int numRead;
        byte[] buf = new byte[16384];
        while ((numRead = in.read(buf)) != -1) {
            out.write(buf, 0, numRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden(reason="XXX: security hole")
    public void perform(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ReplicationAction action;
        String[] pathElements = this.getPathElements(req);
        if (pathElements.length != 2) {
            throw new ServletException("invalid path, must contain shard ID and action, e.g. */s1/update");
        }
        try {
            action = ReplicationAction.valueOf(pathElements[1].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Unsupported action provided: " + pathElements[1]);
        }
        Replicator replicator = this.replicators.get(pathElements[0]);
        if (replicator == null) {
            throw new ServletException("unrecognized shard ID " + pathElements[0]);
        }
        ServletOutputStream resOut = resp.getOutputStream();
        try {
            switch (action) {
                case OBTAIN: {
                    String sessionID = ReplicationService.extractRequestParam(req, REPLICATE_SESSION_ID_PARAM);
                    String fileName = ReplicationService.extractRequestParam(req, REPLICATE_FILENAME_PARAM);
                    String source = ReplicationService.extractRequestParam(req, REPLICATE_SOURCE_PARAM);
                    try (InputStream in = replicator.obtainFile(sessionID, source, fileName);){
                        ReplicationService.copy(in, (OutputStream)resOut);
                        return;
                    }
                }
                case RELEASE: {
                    replicator.release(ReplicationService.extractRequestParam(req, REPLICATE_SESSION_ID_PARAM));
                    return;
                }
                case UPDATE: {
                    String currVersion = req.getParameter(REPLICATE_VERSION_PARAM);
                    SessionToken token = replicator.checkForUpdate(currVersion);
                    if (token == null) {
                        resOut.write(0);
                        return;
                    }
                    resOut.write(1);
                    token.serialize(new DataOutputStream((OutputStream)resOut));
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            resp.setStatus(500);
            try {
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)resOut);
                oos.writeObject(e);
                oos.flush();
                return;
            }
            catch (Exception e2) {
                throw new IOException("Could not serialize", e2);
            }
        }
        finally {
            resp.flushBuffer();
        }
    }

    public static enum ReplicationAction {
        OBTAIN,
        RELEASE,
        UPDATE;

    }
}

