/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

class ReplicaFileDeleter {
    private final Map<String, Integer> refCounts = new HashMap<String, Integer>();
    private final Directory dir;
    private final Node node;

    public ReplicaFileDeleter(Node node, Directory dir) throws IOException {
        this.dir = dir;
        this.node = node;
    }

    private static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    public synchronized void incRef(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            assert (ReplicaFileDeleter.slowFileExists(this.dir, fileName)) : "file " + fileName + " does not exist!";
            Integer curCount = this.refCounts.get(fileName);
            if (curCount == null) {
                this.refCounts.put(fileName, 1);
                continue;
            }
            this.refCounts.put(fileName, curCount + 1);
        }
    }

    public synchronized void decRef(Collection<String> fileNames) throws IOException {
        HashSet<String> toDelete = new HashSet<String>();
        for (String fileName : fileNames) {
            Integer curCount = this.refCounts.get(fileName);
            assert (curCount != null) : "fileName=" + fileName;
            assert (curCount > 0);
            if (curCount == 1) {
                this.refCounts.remove(fileName);
                toDelete.add(fileName);
                continue;
            }
            this.refCounts.put(fileName, curCount - 1);
        }
        this.delete(toDelete);
    }

    private synchronized void delete(Collection<String> toDelete) throws IOException {
        if (Node.VERBOSE_FILES) {
            this.node.message("now delete " + toDelete.size() + " files: " + toDelete);
        }
        for (String fileName : toDelete) {
            assert (!this.refCounts.containsKey(fileName));
            if (!fileName.startsWith("segments")) continue;
            this.delete(fileName);
        }
        for (String fileName : toDelete) {
            assert (!this.refCounts.containsKey(fileName));
            if (fileName.startsWith("segments")) continue;
            this.delete(fileName);
        }
    }

    private synchronized void delete(String fileName) throws IOException {
        if (Node.VERBOSE_FILES) {
            this.node.message("file " + fileName + ": now delete");
        }
        this.dir.deleteFile(fileName);
    }

    public synchronized Integer getRefCount(String fileName) {
        return this.refCounts.get(fileName);
    }

    public synchronized void deleteIfNoRef(String fileName) throws IOException {
        if (!this.refCounts.containsKey(fileName)) {
            this.deleteNewFile(fileName);
        }
    }

    public synchronized void deleteNewFile(String fileName) throws IOException {
        this.delete(fileName);
    }

    public synchronized void deleteUnknownFiles(String segmentsFileName) throws IOException {
        HashSet<String> toDelete = new HashSet<String>();
        for (String fileName : this.dir.listAll()) {
            if (this.refCounts.containsKey(fileName) || fileName.equals("write.lock") || fileName.equals(segmentsFileName)) continue;
            this.node.message("will delete unknown file \"" + fileName + "\"");
            toDelete.add(fileName);
        }
        this.delete(toDelete);
    }
}

