/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.replicator.nrt.CopyState;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.replicator.nrt.PreCopyMergedSegmentWarmer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ThreadInterruptedException;

public abstract class PrimaryNode
extends Node {
    private SegmentInfos curInfos;
    protected final IndexWriter writer;
    private CopyState copyState;
    protected final long primaryGen;
    final Set<String> finishedMergedFiles = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger copyingCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryNode(IndexWriter writer, int id, long primaryGen, long forcePrimaryVersion, SearcherFactory searcherFactory, PrintStream printStream) throws IOException {
        super(id, writer.getDirectory(), searcherFactory, printStream);
        this.message("top: now init primary");
        this.writer = writer;
        this.primaryGen = primaryGen;
        try {
            writer.getConfig().setMergedSegmentWarmer((IndexWriter.IndexReaderWarmer)new PreCopyMergedSegmentWarmer(this));
            this.message("IWC:\n" + writer.getConfig());
            this.message("dir:\n" + writer.getDirectory());
            this.message("commitData: " + writer.getLiveCommitData());
            HashMap commitData = new HashMap();
            Iterable iter = writer.getLiveCommitData();
            if (iter != null) {
                for (Map.Entry ent : iter) {
                    commitData.put(ent.getKey(), ent.getValue());
                }
            }
            commitData.put(PRIMARY_GEN_KEY, Long.toString(primaryGen));
            if (commitData.get(VERSION_KEY) == null) {
                commitData.put(VERSION_KEY, "0");
                this.message("add initial commitData version=0");
            } else {
                this.message("keep current commitData version=" + (String)commitData.get(VERSION_KEY));
            }
            writer.setLiveCommitData(commitData.entrySet(), false);
            if (forcePrimaryVersion != -1L) {
                this.message("now forcePrimaryVersion to version=" + forcePrimaryVersion);
                writer.advanceSegmentInfosVersion(forcePrimaryVersion);
            }
            this.mgr = new SearcherManager(writer, true, true, searcherFactory);
            this.setCurrentInfos(Collections.emptySet());
            this.message("init: infos version=" + this.curInfos.getVersion());
            IndexSearcher s = (IndexSearcher)this.mgr.acquire();
            try {
                this.message("init: marker count: " + s.count((Query)new TermQuery(new Term("marker", "marker"))));
            }
            finally {
                this.mgr.release((Object)s);
            }
        }
        catch (Throwable t) {
            this.message("init: exception");
            t.printStackTrace(printStream);
            throw new RuntimeException(t);
        }
    }

    public long getPrimaryGen() {
        return this.primaryGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAndRefresh() throws IOException {
        Set<String> completedMergeFiles;
        this.message("top: now flushAndRefresh");
        Set<String> set = this.finishedMergedFiles;
        synchronized (set) {
            completedMergeFiles = Collections.unmodifiableSet(new HashSet<String>(this.finishedMergedFiles));
        }
        this.mgr.maybeRefreshBlocking();
        boolean result = this.setCurrentInfos(completedMergeFiles);
        if (result) {
            this.message("top: opened NRT reader version=" + this.curInfos.getVersion());
            this.finishedMergedFiles.removeAll(completedMergeFiles);
            this.message("flushAndRefresh: version=" + this.curInfos.getVersion() + " completedMergeFiles=" + completedMergeFiles + " finishedMergedFiles=" + this.finishedMergedFiles);
        } else {
            this.message("top: no changes in flushAndRefresh; still version=" + this.curInfos.getVersion());
        }
        return result;
    }

    public long getCopyStateVersion() {
        return this.copyState.version;
    }

    public synchronized long getLastCommitVersion() {
        Iterable iter = this.writer.getLiveCommitData();
        assert (iter != null);
        for (Map.Entry ent : iter) {
            if (!((String)ent.getKey()).equals(VERSION_KEY)) continue;
            return Long.parseLong((String)ent.getValue());
        }
        throw new AssertionError((Object)"missing VERSION_KEY");
    }

    @Override
    public void commit() throws IOException {
        HashMap<String, String> commitData = new HashMap<String, String>();
        commitData.put(PRIMARY_GEN_KEY, Long.toString(this.primaryGen));
        commitData.put(VERSION_KEY, Long.toString(this.copyState.version));
        this.message("top: commit commitData=" + commitData);
        this.writer.setLiveCommitData(commitData.entrySet(), false);
        this.writer.commit();
    }

    public synchronized CopyState getCopyState() throws IOException {
        this.ensureOpen(false);
        assert (this.curInfos == this.copyState.infos);
        this.writer.incRefDeleter(this.copyState.infos);
        int count = this.copyingCount.incrementAndGet();
        assert (count > 0);
        return this.copyState;
    }

    public void releaseCopyState(CopyState copyState) throws IOException {
        assert (copyState.infos != null);
        this.writer.decRefDeleter(copyState.infos);
        int count = this.copyingCount.decrementAndGet();
        assert (count >= 0);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed(false);
    }

    boolean isClosed(boolean allowClosing) {
        return "closed".equals(this.state) || !allowClosing && "closing".equals(this.state);
    }

    private void ensureOpen(boolean allowClosing) {
        if (this.isClosed(allowClosing)) {
            throw new AlreadyClosedException(this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean setCurrentInfos(Set<String> completedMergeFiles) throws IOException {
        SegmentInfos infos;
        IndexSearcher searcher = null;
        try {
            searcher = (IndexSearcher)this.mgr.acquire();
            infos = ((StandardDirectoryReader)searcher.getIndexReader()).getSegmentInfos();
            this.message("setCurrentInfos: marker count: " + searcher.count((Query)new TermQuery(new Term("marker", "marker"))) + " version=" + infos.getVersion() + " searcher=" + searcher);
        }
        finally {
            if (searcher != null) {
                this.mgr.release((Object)searcher);
            }
        }
        if (this.curInfos != null && infos.getVersion() == this.curInfos.getVersion()) {
            this.message("top: skip switch to infos: version=" + infos.getVersion() + " is unchanged: " + infos.toString());
            return false;
        }
        SegmentInfos oldInfos = this.curInfos;
        this.writer.incRefDeleter(infos);
        this.curInfos = infos;
        if (oldInfos != null) {
            this.writer.decRefDeleter(oldInfos);
        }
        this.message("top: switch to infos=" + infos.toString() + " version=" + infos.getVersion());
        RAMOutputStream out = new RAMOutputStream(new RAMFile(), true);
        infos.write(this.dir, (IndexOutput)out);
        byte[] infosBytes = new byte[(int)out.getFilePointer()];
        out.writeTo(infosBytes, 0);
        HashMap<String, FileMetaData> filesMetaData = new HashMap<String, FileMetaData>();
        for (SegmentCommitInfo info : infos) {
            for (String fileName : info.files()) {
                FileMetaData metaData = this.readLocalFileMetaData(fileName);
                assert (metaData != null);
                assert (!filesMetaData.containsKey(fileName));
                filesMetaData.put(fileName, metaData);
            }
        }
        this.lastFileMetaData = Collections.unmodifiableMap(filesMetaData);
        this.message("top: set copyState primaryGen=" + this.primaryGen + " version=" + infos.getVersion() + " files=" + filesMetaData.keySet());
        this.copyState = new CopyState(this.lastFileMetaData, infos.getVersion(), infos.getGeneration(), infosBytes, completedMergeFiles, this.primaryGen, this.curInfos);
        return true;
    }

    private synchronized void waitForAllRemotesToClose() throws IOException {
        int count;
        while ((count = this.copyingCount.get()) != 0) {
            this.message("pendingCopies: " + count);
            try {
                this.wait(10L);
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.state = "closing";
        this.message("top: close primary");
        PrimaryNode primaryNode = this;
        synchronized (primaryNode) {
            this.waitForAllRemotesToClose();
            if (this.curInfos != null) {
                this.writer.decRefDeleter(this.curInfos);
                this.curInfos = null;
            }
        }
        this.mgr.close();
        this.writer.rollback();
        this.dir.close();
        this.state = "closed";
    }

    protected abstract void preCopyMergedSegmentFiles(SegmentCommitInfo var1, Map<String, FileMetaData> var2) throws IOException;
}

