/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.replicator.IndexInputInputStream;
import org.apache.lucene.replicator.IndexRevision;
import org.apache.lucene.replicator.Revision;
import org.apache.lucene.replicator.RevisionFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class IndexAndTaxonomyRevision
implements Revision {
    private static final int RADIX = 16;
    public static final String INDEX_SOURCE = "index";
    public static final String TAXONOMY_SOURCE = "taxo";
    private final IndexWriter indexWriter;
    private final SnapshotDirectoryTaxonomyWriter taxoWriter;
    private final IndexCommit indexCommit;
    private final IndexCommit taxoCommit;
    private final SnapshotDeletionPolicy indexSDP;
    private final SnapshotDeletionPolicy taxoSDP;
    private final String version;
    private final Map<String, List<RevisionFile>> sourceFiles;

    public static Map<String, List<RevisionFile>> revisionFiles(IndexCommit indexCommit, IndexCommit taxoCommit) throws IOException {
        HashMap<String, List<RevisionFile>> files = new HashMap<String, List<RevisionFile>>();
        files.put(INDEX_SOURCE, IndexRevision.revisionFiles(indexCommit).values().iterator().next());
        files.put(TAXONOMY_SOURCE, IndexRevision.revisionFiles(taxoCommit).values().iterator().next());
        return files;
    }

    public static String revisionVersion(IndexCommit indexCommit, IndexCommit taxoCommit) {
        return Long.toString(indexCommit.getGeneration(), 16) + ":" + Long.toString(taxoCommit.getGeneration(), 16);
    }

    public IndexAndTaxonomyRevision(IndexWriter indexWriter, SnapshotDirectoryTaxonomyWriter taxoWriter) throws IOException {
        IndexDeletionPolicy delPolicy = indexWriter.getConfig().getIndexDeletionPolicy();
        if (!(delPolicy instanceof SnapshotDeletionPolicy)) {
            throw new IllegalArgumentException("IndexWriter must be created with SnapshotDeletionPolicy");
        }
        this.indexWriter = indexWriter;
        this.taxoWriter = taxoWriter;
        this.indexSDP = (SnapshotDeletionPolicy)delPolicy;
        this.taxoSDP = taxoWriter.getDeletionPolicy();
        this.indexCommit = this.indexSDP.snapshot();
        this.taxoCommit = this.taxoSDP.snapshot();
        this.version = IndexAndTaxonomyRevision.revisionVersion(this.indexCommit, this.taxoCommit);
        this.sourceFiles = IndexAndTaxonomyRevision.revisionFiles(this.indexCommit, this.taxoCommit);
    }

    @Override
    public int compareTo(String version) {
        String[] parts = version.split(":");
        long indexGen = Long.parseLong(parts[0], 16);
        long taxoGen = Long.parseLong(parts[1], 16);
        long indexCommitGen = this.indexCommit.getGeneration();
        long taxoCommitGen = this.taxoCommit.getGeneration();
        if (indexCommitGen < indexGen) {
            return -1;
        }
        if (indexCommitGen > indexGen) {
            return 1;
        }
        return taxoCommitGen < taxoGen ? -1 : (taxoCommitGen > taxoGen ? 1 : 0);
    }

    @Override
    public int compareTo(Revision o) {
        IndexAndTaxonomyRevision other = (IndexAndTaxonomyRevision)o;
        int cmp = this.indexCommit.compareTo(other.indexCommit);
        return cmp != 0 ? cmp : this.taxoCommit.compareTo(other.taxoCommit);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, List<RevisionFile>> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public InputStream open(String source, String fileName) throws IOException {
        assert (source.equals(INDEX_SOURCE) || source.equals(TAXONOMY_SOURCE)) : "invalid source; expected=(index or taxo) got=" + source;
        IndexCommit ic = source.equals(INDEX_SOURCE) ? this.indexCommit : this.taxoCommit;
        return new IndexInputInputStream(ic.getDirectory().openInput(fileName, IOContext.READONCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws IOException {
        try {
            this.indexSDP.release(this.indexCommit);
        }
        finally {
            this.taxoSDP.release(this.taxoCommit);
        }
        try {
            this.indexWriter.deleteUnusedFiles();
        }
        finally {
            this.taxoWriter.getIndexWriter().deleteUnusedFiles();
        }
    }

    public String toString() {
        return "IndexAndTaxonomyRevision version=" + this.version + " files=" + this.sourceFiles;
    }

    public static final class SnapshotDirectoryTaxonomyWriter
    extends DirectoryTaxonomyWriter {
        private SnapshotDeletionPolicy sdp;
        private IndexWriter writer;

        public SnapshotDirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode, TaxonomyWriterCache cache) throws IOException {
            super(directory, openMode, cache);
        }

        public SnapshotDirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode) throws IOException {
            super(directory, openMode);
        }

        public SnapshotDirectoryTaxonomyWriter(Directory d) throws IOException {
            super(d);
        }

        protected IndexWriterConfig createIndexWriterConfig(IndexWriterConfig.OpenMode openMode) {
            IndexWriterConfig conf = super.createIndexWriterConfig(openMode);
            conf.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy(conf.getIndexDeletionPolicy()));
            return conf;
        }

        protected IndexWriter openIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
            this.writer = super.openIndexWriter(directory, config);
            this.sdp = (SnapshotDeletionPolicy)this.writer.getConfig().getIndexDeletionPolicy();
            return this.writer;
        }

        public SnapshotDeletionPolicy getDeletionPolicy() {
            return this.sdp;
        }

        public IndexWriter getIndexWriter() {
            return this.writer;
        }
    }
}

