/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.replicator.IndexRevision;
import org.apache.lucene.replicator.ReplicationClient;
import org.apache.lucene.replicator.RevisionFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

public class IndexReplicationHandler
implements ReplicationClient.ReplicationHandler {
    public static final String INFO_STREAM_COMPONENT = "IndexReplicationHandler";
    private final Directory indexDir;
    private final Callable<Boolean> callback;
    private volatile Map<String, List<RevisionFile>> currentRevisionFiles;
    private volatile String currentVersion;
    private volatile InfoStream infoStream = InfoStream.getDefault();

    public static IndexCommit getLastCommit(Directory dir) throws IOException {
        try {
            if (DirectoryReader.indexExists((Directory)dir)) {
                List commits = DirectoryReader.listCommits((Directory)dir);
                return (IndexCommit)commits.get(commits.size() - 1);
            }
        }
        catch (IndexNotFoundException indexNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static String getSegmentsFile(List<String> files, boolean allowEmpty) {
        if (files.isEmpty()) {
            if (allowEmpty) {
                return null;
            }
            throw new IllegalStateException("empty list of files not allowed");
        }
        String segmentsFile = files.remove(files.size() - 1);
        if (!segmentsFile.startsWith("segments") || segmentsFile.equals("segments.gen")) {
            throw new IllegalStateException("last file to copy+sync must be segments_N but got " + segmentsFile + "; check your Revision implementation!");
        }
        return segmentsFile;
    }

    public static void cleanupFilesOnFailure(Directory dir, List<String> files) {
        for (String file : files) {
            IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])new String[]{file});
        }
    }

    public static void cleanupOldIndexFiles(Directory dir, String segmentsFile, InfoStream infoStream) {
        block4: {
            try {
                IndexCommit commit = IndexReplicationHandler.getLastCommit(dir);
                if (commit != null && commit.getSegmentsFileName().equals(segmentsFile)) {
                    HashSet<String> commitFiles = new HashSet<String>();
                    commitFiles.addAll(commit.getFileNames());
                    commitFiles.add("segments.gen");
                    Matcher matcher = IndexFileNames.CODEC_FILE_PATTERN.matcher("");
                    for (String file : dir.listAll()) {
                        if (commitFiles.contains(file) || !matcher.reset(file).matches() && !file.startsWith("segments")) continue;
                        IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])new String[]{file});
                    }
                }
            }
            catch (Throwable t) {
                if (!infoStream.isEnabled(INFO_STREAM_COMPONENT)) break block4;
                infoStream.message(INFO_STREAM_COMPONENT, "cleanupOldIndexFiles(): failed on error " + t.getMessage());
            }
        }
    }

    public static void copyFiles(Directory source, Directory target, List<String> files) throws IOException {
        if (!source.equals(target)) {
            for (String file : files) {
                source.copy(target, file, file, IOContext.READONCE);
            }
        }
    }

    public static void writeSegmentsGen(String segmentsFile, Directory dir) {
        if (segmentsFile != null) {
            SegmentInfos.writeSegmentsGen((Directory)dir, (long)SegmentInfos.generationFromSegmentsFileName((String)segmentsFile));
        } else {
            IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])new String[]{"segments.gen"});
        }
    }

    public IndexReplicationHandler(Directory indexDir, Callable<Boolean> callback) throws IOException {
        this.callback = callback;
        this.indexDir = indexDir;
        this.currentRevisionFiles = null;
        this.currentVersion = null;
        if (DirectoryReader.indexExists((Directory)indexDir)) {
            List commits = DirectoryReader.listCommits((Directory)indexDir);
            IndexCommit commit = (IndexCommit)commits.get(commits.size() - 1);
            this.currentRevisionFiles = IndexRevision.revisionFiles(commit);
            this.currentVersion = IndexRevision.revisionVersion(commit);
            InfoStream infoStream = InfoStream.getDefault();
            if (infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
                infoStream.message(INFO_STREAM_COMPONENT, "constructor(): currentVersion=" + this.currentVersion + " currentRevisionFiles=" + this.currentRevisionFiles);
                infoStream.message(INFO_STREAM_COMPONENT, "constructor(): commit=" + commit);
            }
        }
    }

    @Override
    public String currentVersion() {
        return this.currentVersion;
    }

    @Override
    public Map<String, List<RevisionFile>> currentRevisionFiles() {
        return this.currentRevisionFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revisionReady(String version, Map<String, List<RevisionFile>> revisionFiles, Map<String, List<String>> copiedFiles, Map<String, Directory> sourceDirectory) throws IOException {
        if (revisionFiles.size() > 1) {
            throw new IllegalArgumentException("this handler handles only a single source; got " + revisionFiles.keySet());
        }
        Directory clientDir = sourceDirectory.values().iterator().next();
        List<String> files = copiedFiles.values().iterator().next();
        String segmentsFile = IndexReplicationHandler.getSegmentsFile(files, false);
        boolean success = false;
        try {
            IndexReplicationHandler.copyFiles(clientDir, this.indexDir, files);
            this.indexDir.sync(files);
            clientDir.copy(this.indexDir, segmentsFile, segmentsFile, IOContext.READONCE);
            this.indexDir.sync(Collections.singletonList(segmentsFile));
            success = true;
        }
        finally {
            if (!success) {
                files.add(segmentsFile);
                IndexReplicationHandler.cleanupFilesOnFailure(this.indexDir, files);
            }
        }
        this.currentRevisionFiles = revisionFiles;
        this.currentVersion = version;
        if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
            this.infoStream.message(INFO_STREAM_COMPONENT, "revisionReady(): currentVersion=" + this.currentVersion + " currentRevisionFiles=" + this.currentRevisionFiles);
        }
        IndexReplicationHandler.writeSegmentsGen(segmentsFile, this.indexDir);
        IndexReplicationHandler.cleanupOldIndexFiles(this.indexDir, segmentsFile, this.infoStream);
        if (this.callback != null) {
            try {
                this.callback.call();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void setInfoStream(InfoStream infoStream) {
        if (infoStream == null) {
            infoStream = InfoStream.NO_OUTPUT;
        }
        this.infoStream = infoStream;
    }
}

