/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.queries.spans.SpanCollector;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanScorer;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;

public abstract class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Similarity.SimScorer simScorer;
    protected final String field;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        super((Query)query);
        this.field = query.getField();
        this.similarity = searcher.getSimilarity();
        this.simScorer = this.buildSimWeight(query, searcher, termStates, boost);
    }

    private Similarity.SimScorer buildSimWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermStates> termStates, float boost) throws IOException {
        if (termStates == null || termStates.size() == 0 || query.getField() == null) {
            return null;
        }
        Object[] termStats = new TermStatistics[termStates.size()];
        int termUpTo = 0;
        for (Map.Entry<Term, TermStates> entry : termStates.entrySet()) {
            TermStates ts = entry.getValue();
            if (ts.docFreq() <= 0) continue;
            termStats[termUpTo++] = searcher.termStatistics(entry.getKey(), ts.docFreq(), ts.totalTermFreq());
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(query.getField());
        if (termUpTo > 0) {
            return this.similarity.scorer(boost, collectionStats, (TermStatistics[])ArrayUtil.copyOfSubArray((Object[])termStats, (int)0, (int)termUpTo));
        }
        return null;
    }

    public abstract void extractTermStates(Map<Term, TermStates> var1);

    public abstract Spans getSpans(LeafReaderContext var1, Postings var2) throws IOException;

    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        Spans spans = this.getSpans(context, Postings.POSITIONS);
        if (spans == null) {
            return null;
        }
        NumericDocValues norms = context.reader().getNormValues(this.field);
        final SpanScorer scorer = new SpanScorer(spans, this.simScorer, norms);
        return new ScorerSupplier(this){

            public SpanScorer get(long leadCost) throws IOException {
                return scorer;
            }

            public long cost() {
                return scorer.iterator().cost();
            }
        };
    }

    public Similarity.SimScorer getSimScorer() {
        return this.simScorer;
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int newDoc;
        SpanScorer scorer = (SpanScorer)this.scorer(context);
        if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
            if (this.simScorer != null) {
                float freq = scorer.sloppyFreq();
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), (String)("phraseFreq=" + freq), (Explanation[])new Explanation[0]);
                NumericDocValues norms = context.reader().getNormValues(this.field);
                long norm = 1L;
                if (norms != null && norms.advanceExact(doc)) {
                    norm = norms.longValue();
                }
                Explanation scoreExplanation = this.simScorer.explain(freqExplanation, norm);
                return Explanation.match((Number)scoreExplanation.getValue(), (String)("weight(" + String.valueOf(this.getQuery()) + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:"), (Explanation[])new Explanation[]{scoreExplanation});
            }
            return Explanation.match((Number)Float.valueOf(0.0f), (String)String.format(Locale.ROOT, "match %s in %s without score", this.getQuery(), doc), (Explanation[])new Explanation[0]);
        }
        return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
    }

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return MatchesUtils.forField((String)this.field, () -> {
            final Spans spans = this.getSpans(context, Postings.OFFSETS);
            if (spans == null || spans.advance(doc) != doc) {
                return null;
            }
            return new MatchesIterator(){
                int innerTermCount = 0;
                TermMatch[] innerTerms = new TermMatch[0];
                SpanCollector termCollector = new SpanCollector(){

                    @Override
                    public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
                        ++innerTermCount;
                        if (innerTermCount > innerTerms.length) {
                            TermMatch[] temp = new TermMatch[innerTermCount];
                            System.arraycopy(innerTerms, 0, temp, 0, innerTermCount - 1);
                            innerTerms = temp;
                            innerTerms[innerTermCount - 1] = new TermMatch();
                        }
                        innerTerms[innerTermCount - 1].term = term;
                        innerTerms[innerTermCount - 1].position = position;
                        innerTerms[innerTermCount - 1].startOffset = postings.startOffset();
                        innerTerms[innerTermCount - 1].endOffset = postings.endOffset();
                    }

                    @Override
                    public void reset() {
                        innerTermCount = 0;
                    }
                };
                final /* synthetic */ SpanWeight this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean next() throws IOException {
                    this.innerTermCount = 0;
                    return spans.nextStartPosition() != Integer.MAX_VALUE;
                }

                public int startPosition() {
                    return spans.startPosition();
                }

                public int endPosition() {
                    return spans.endPosition() - 1;
                }

                public int startOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[0].startOffset;
                }

                public int endOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[this.innerTermCount - 1].endOffset;
                }

                public MatchesIterator getSubMatches() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return new MatchesIterator(){
                        int upto = -1;

                        public boolean next() throws IOException {
                            ++this.upto;
                            return this.upto < innerTermCount;
                        }

                        public int startPosition() {
                            return innerTerms[this.upto].position;
                        }

                        public int endPosition() {
                            return innerTerms[this.upto].position;
                        }

                        public int startOffset() throws IOException {
                            return innerTerms[this.upto].startOffset;
                        }

                        public int endOffset() throws IOException {
                            return innerTerms[this.upto].endOffset;
                        }

                        public MatchesIterator getSubMatches() throws IOException {
                            return null;
                        }

                        public Query getQuery() {
                            return new TermQuery(innerTerms[this.upto].term);
                        }
                    };
                }

                public Query getQuery() {
                    return this.this$0.getQuery();
                }

                void collectInnerTerms() throws IOException {
                    this.termCollector.reset();
                    spans.collect(this.termCollector);
                    Arrays.sort(this.innerTerms, 0, this.innerTermCount, Comparator.comparing(a -> a.position));
                }
            };
        });
    }

    public static enum Postings {
        POSITIONS{

            @Override
            public int getRequiredPostings() {
                return 24;
            }
        }
        ,
        PAYLOADS{

            @Override
            public int getRequiredPostings() {
                return 88;
            }
        }
        ,
        OFFSETS{

            @Override
            public int getRequiredPostings() {
                return 120;
            }
        };


        public abstract int getRequiredPostings();

        public Postings atLeast(Postings postings) {
            if (postings.compareTo(this) > 0) {
                return postings;
            }
            return this;
        }
    }

    private static class TermMatch {
        Term term;
        int position;
        int startOffset;
        int endOffset;

        private TermMatch() {
        }
    }
}

