/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiFunction;

public abstract class VectorSimilarityFunction
extends ValueSource {
    protected final org.apache.lucene.index.VectorSimilarityFunction similarityFunction;
    protected final ValueSource vector1;
    protected final ValueSource vector2;

    public VectorSimilarityFunction(org.apache.lucene.index.VectorSimilarityFunction similarityFunction, ValueSource vector1, ValueSource vector2) {
        this.similarityFunction = similarityFunction;
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vector1Vals = this.vector1.getValues(context, readerContext);
        final FunctionValues vector2Vals = this.vector2.getValues(context, readerContext);
        return new FunctionValues(this){
            final /* synthetic */ VectorSimilarityFunction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public float floatVal(int doc) throws IOException {
                return this.this$0.func(doc, vector1Vals, vector2Vals);
            }

            @Override
            public String strVal(int doc) throws IOException {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return MultiFunction.allExists(doc, vector1Vals, vector2Vals);
            }

            @Override
            public String toString(int doc) throws IOException {
                return this.this$0.description() + " = " + this.strVal(doc);
            }
        };
    }

    protected abstract float func(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.vector1, ((VectorSimilarityFunction)o).vector1) && Objects.equals(this.vector2, ((VectorSimilarityFunction)o).vector2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.similarityFunction, this.vector1, this.vector2);
    }

    @Override
    public String description() {
        return this.similarityFunction.name() + "(" + this.vector1.description() + ", " + this.vector2.description() + ")";
    }
}

