/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.util.BytesRef;

public class TermFreqValueSource
extends DocFreqValueSource {
    public TermFreqValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        super(field, val, indexedField, indexedBytes);
    }

    @Override
    public String name() {
        return "termfreq";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final Terms terms = Terms.getTerms((LeafReader)readerContext.reader(), (String)this.indexedField);
        return new IntDocValues(this, this){
            PostingsEnum docs;
            int atDoc;
            int lastDocRequested;
            final /* synthetic */ TermFreqValueSource this$0;
            {
                this.this$0 = this$0;
                super(vs);
                this.lastDocRequested = -1;
                this.reset();
            }

            public void reset() throws IOException {
                TermsEnum termsEnum = terms.iterator();
                this.docs = termsEnum.seekExact(this.this$0.indexedBytes) ? termsEnum.postings(null) : null;
                if (this.docs == null) {
                    this.docs = new PostingsEnum(this){

                        public int freq() {
                            return 0;
                        }

                        public int nextPosition() throws IOException {
                            return -1;
                        }

                        public int startOffset() throws IOException {
                            return -1;
                        }

                        public int endOffset() throws IOException {
                            return -1;
                        }

                        public BytesRef getPayload() throws IOException {
                            throw new UnsupportedOperationException();
                        }

                        public int docID() {
                            return Integer.MAX_VALUE;
                        }

                        public int nextDoc() {
                            return Integer.MAX_VALUE;
                        }

                        public int advance(int target) {
                            return Integer.MAX_VALUE;
                        }

                        public long cost() {
                            return 0L;
                        }
                    };
                }
                this.atDoc = -1;
            }

            @Override
            public int intVal(int doc) {
                try {
                    if (doc < this.lastDocRequested) {
                        this.reset();
                    }
                    this.lastDocRequested = doc;
                    if (this.atDoc < doc) {
                        this.atDoc = this.docs.advance(doc);
                    }
                    if (this.atDoc > doc) {
                        return 0;
                    }
                    return this.docs.freq();
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in function " + this.this$0.description() + " : doc=" + doc, e);
                }
            }
        };
    }
}

