/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortField;

public class LongFieldSource
extends FieldCacheSource {
    public LongFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "long(" + this.field + ")";
    }

    public long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    public Object longToObject(long val) {
        return val;
    }

    public String longToString(long val) {
        return this.longToObject(val).toString();
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.LONG, reverse);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        return new LongDocValues(this, this){
            int lastDocID;
            final /* synthetic */ LongFieldSource this$0;
            {
                this.this$0 = this$0;
                super(vs);
            }

            @Override
            public long longVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return arr.longValue();
                }
                return 0L;
            }

            @Override
            public boolean exists(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                return doc == curDocID;
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    long value = this.longVal(doc);
                    return this.this$0.longToObject(value);
                }
                return null;
            }

            @Override
            public String strVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    long value = this.longVal(doc);
                    return this.this$0.longToString(value);
                }
                return null;
            }

            @Override
            protected long externalToLong(String extVal) {
                return this.this$0.externalToLong(extVal);
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LongFieldSource other = (LongFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        return h += super.hashCode();
    }
}

