/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoublePredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class FunctionMatchQuery
extends Query {
    static final float DEFAULT_MATCH_COST = 100.0f;
    private final DoubleValuesSource source;
    private final DoublePredicate filter;
    private final float matchCost;

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter) {
        this(source, filter, 100.0f);
    }

    public FunctionMatchQuery(DoubleValuesSource source, DoublePredicate filter, float matchCost) {
        this.source = source;
        this.filter = filter;
        this.matchCost = matchCost;
    }

    public String toString(String field) {
        return "FunctionMatchQuery(" + this.source.toString() + ")";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final DoubleValuesSource vs = this.source.rewrite(searcher);
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ FunctionMatchQuery this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final DoubleValues values = vs.getValues(context, null);
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(this, approximation){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    public boolean matches() throws IOException {
                        return values.advanceExact(this.approximation.docID()) && this.this$1.this$0.filter.test(values.doubleValue());
                    }

                    public float matchCost() {
                        return this.this$1.this$0.matchCost;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return this.this$0.source.isCacheable(ctx);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionMatchQuery that = (FunctionMatchQuery)((Object)o);
        return Objects.equals(this.source, that.source) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.filter);
    }
}

