/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;

public final class DocumentField {
    private String name;
    private IndexOptions idxOptions;
    private boolean hasTermVectors;
    private boolean hasPayloads;
    private boolean hasNorms;
    private long norm;
    private boolean isStored;
    private String stringValue;
    private BytesRef binaryValue;
    private Number numericValue;
    private DocValuesType dvType;
    private int pointDimensionCount;
    private int pointNumBytes;
    private int vectorDimension;
    private VectorSimilarityFunction vectorSimilarity;

    static DocumentField of(FieldInfo finfo, IndexReader reader, int docId) throws IOException {
        return DocumentField.of(finfo, null, reader, docId);
    }

    static DocumentField of(FieldInfo finfo, IndexableField field, IndexReader reader, int docId) throws IOException {
        NumericDocValues norms;
        Objects.requireNonNull(finfo);
        Objects.requireNonNull(reader);
        DocumentField dfield = new DocumentField();
        dfield.name = finfo.name;
        dfield.idxOptions = finfo.getIndexOptions();
        dfield.hasTermVectors = finfo.hasVectors();
        dfield.hasPayloads = finfo.hasPayloads();
        dfield.hasNorms = finfo.hasNorms();
        if (finfo.hasNorms() && (norms = MultiDocValues.getNormValues((IndexReader)reader, (String)finfo.name)).advanceExact(docId)) {
            dfield.norm = norms.longValue();
        }
        dfield.dvType = finfo.getDocValuesType();
        dfield.pointDimensionCount = finfo.getPointDimensionCount();
        dfield.pointNumBytes = finfo.getPointNumBytes();
        dfield.vectorDimension = finfo.getVectorDimension();
        dfield.vectorSimilarity = finfo.getVectorSimilarityFunction();
        if (field != null) {
            dfield.isStored = field.fieldType().stored();
            dfield.stringValue = field.stringValue();
            if (field.binaryValue() != null) {
                dfield.binaryValue = BytesRef.deepCopyOf((BytesRef)field.binaryValue());
            }
            dfield.numericValue = field.numericValue();
        }
        return dfield;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions getIdxOptions() {
        return this.idxOptions;
    }

    public boolean hasTermVectors() {
        return this.hasTermVectors;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public long getNorm() {
        return this.norm;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public BytesRef getBinaryValue() {
        return this.binaryValue;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public DocValuesType getDvType() {
        return this.dvType;
    }

    public int getPointDimensionCount() {
        return this.pointDimensionCount;
    }

    public int getPointNumBytes() {
        return this.pointNumBytes;
    }

    public int getVectorDimension() {
        return this.vectorDimension;
    }

    public VectorSimilarityFunction getVectorSimilarity() {
        return this.vectorSimilarity;
    }

    public String toString() {
        return "DocumentField{name='" + this.name + "', idxOptions=" + this.idxOptions + ", hasTermVectors=" + this.hasTermVectors + ", isStored=" + this.isStored + ", dvType=" + this.dvType + ", pointDimensionCount=" + this.pointDimensionCount + ", vectorDimension=" + this.vectorDimension + "}";
    }

    private DocumentField() {
    }
}

