/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.DocumentsTabOperator;
import org.apache.lucene.luke.app.desktop.components.SearchTabOperator;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.overview.Overview;
import org.apache.lucene.luke.models.overview.OverviewFactory;
import org.apache.lucene.luke.models.overview.TermCountsOrder;
import org.apache.lucene.luke.models.overview.TermStats;

public final class OverviewPanelProvider {
    private static final int GRIDX_DESC = 0;
    private static final int GRIDX_VAL = 1;
    private static final double WEIGHTX_DESC = 0.1;
    private static final double WEIGHTX_VAL = 0.9;
    private final OverviewFactory overviewFactory = new OverviewFactory();
    private final ComponentOperatorRegistry operatorRegistry;
    private final TabSwitcherProxy tabSwitcher;
    private final MessageBroker messageBroker;
    private final JPanel panel = new JPanel();
    private final JLabel indexPathLbl = new JLabel();
    private final JLabel numFieldsLbl = new JLabel();
    private final JLabel numDocsLbl = new JLabel();
    private final JLabel numTermsLbl = new JLabel();
    private final JLabel delOptLbl = new JLabel();
    private final JLabel indexVerLbl = new JLabel();
    private final JLabel indexFmtLbl = new JLabel();
    private final JLabel dirImplLbl = new JLabel();
    private final JLabel commitPointLbl = new JLabel();
    private final JLabel commitUserDataLbl = new JLabel();
    private final JTable termCountsTable = new JTable();
    private final JTextField selectedField = new JTextField();
    private final JButton showTopTermsBtn = new JButton();
    private final JSpinner numTopTermsSpnr = new JSpinner();
    private final JTable topTermsTable = new JTable();
    private final JPopupMenu topTermsContextMenu = new JPopupMenu();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private Overview overviewModel;

    public OverviewPanelProvider() {
        this.messageBroker = MessageBroker.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        IndexHandler.getInstance().addObserver(new Observer());
    }

    public JPanel get() {
        this.panel.setOpaque(false);
        this.panel.setLayout(new GridLayout(1, 1));
        this.panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JSplitPane splitPane = new JSplitPane(0, this.initUpperPanel(), this.initLowerPanel());
        splitPane.setDividerLocation(0.4);
        splitPane.setOpaque(false);
        this.panel.add(splitPane);
        this.setUpTopTermsContextMenu();
        return this.panel;
    }

    private JPanel initUpperPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 10, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.index_path"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.indexPathLbl.setText("?");
        panel.add((Component)this.indexPathLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.num_fields"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.numFieldsLbl.setText("?");
        panel.add((Component)this.numFieldsLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.num_docs"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.numDocsLbl.setText("?");
        panel.add((Component)this.numDocsLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.num_terms"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.numTermsLbl.setText("?");
        panel.add((Component)this.numTermsLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.del_opt"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.delOptLbl.setText("?");
        panel.add((Component)this.delOptLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.index_version"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.indexVerLbl.setText("?");
        panel.add((Component)this.indexVerLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.index_format"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.indexFmtLbl.setText("?");
        panel.add((Component)this.indexFmtLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.dir_impl"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.dirImplLbl.setText("?");
        panel.add((Component)this.dirImplLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.commit_point"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.commitPointLbl.setText("?");
        panel.add((Component)this.commitPointLbl, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.1;
        panel.add((Component)new JLabel(MessageUtils.getLocalizedMessage("overview.label.commit_userdata"), 4), c);
        c.gridx = 1;
        c.weightx = 0.9;
        this.commitUserDataLbl.setText("?");
        panel.add((Component)this.commitUserDataLbl, c);
        return panel;
    }

    private JPanel initLowerPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("overview.label.select_fields"));
        label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add((Component)label, "First");
        JSplitPane splitPane = new JSplitPane(1, this.initTermCountsPanel(), this.initTopTermsPanel());
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(320);
        splitPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)splitPane, "Center");
        return panel;
    }

    private JPanel initTermCountsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("overview.label.available_fields"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        panel.add((Component)label, "First");
        TableUtils.setupTable(this.termCountsTable, 0, new TermCountsTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OverviewPanelProvider.this.listeners.selectField(e);
            }
        }, TermCountsTableModel.Column.NAME.getColumnWidth(), TermCountsTableModel.Column.TERM_COUNT.getColumnWidth());
        JScrollPane scrollPane = new JScrollPane(this.termCountsTable);
        panel.add((Component)scrollPane, "Center");
        panel.setOpaque(false);
        return panel;
    }

    private JPanel initTopTermsPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        JPanel selectedPanel = new JPanel(new BorderLayout());
        selectedPanel.setOpaque(false);
        JPanel innerPanel = new JPanel();
        innerPanel.setOpaque(false);
        innerPanel.setLayout(new BoxLayout(innerPanel, 3));
        innerPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        selectedPanel.add((Component)innerPanel, "First");
        JPanel innerPanel1 = new JPanel(new FlowLayout(3));
        innerPanel1.setOpaque(false);
        innerPanel1.add(new JLabel(MessageUtils.getLocalizedMessage("overview.label.selected_field")));
        innerPanel.add(innerPanel1);
        this.selectedField.setColumns(20);
        this.selectedField.setPreferredSize(new Dimension(100, 30));
        this.selectedField.setFont(StyleConstants.FONT_MONOSPACE_LARGE);
        this.selectedField.setEditable(false);
        this.selectedField.setBackground(Color.white);
        JPanel innerPanel2 = new JPanel(new FlowLayout(3));
        innerPanel2.setOpaque(false);
        innerPanel2.add(this.selectedField);
        innerPanel.add(innerPanel2);
        this.showTopTermsBtn.setText(MessageUtils.getLocalizedMessage("overview.button.show_terms"));
        this.showTopTermsBtn.setPreferredSize(new Dimension(170, 40));
        this.showTopTermsBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.showTopTermsBtn.addActionListener(this.listeners::showTopTerms);
        this.showTopTermsBtn.setEnabled(false);
        JPanel innerPanel3 = new JPanel(new FlowLayout(3));
        innerPanel3.setOpaque(false);
        innerPanel3.add(this.showTopTermsBtn);
        innerPanel.add(innerPanel3);
        JPanel innerPanel4 = new JPanel(new FlowLayout(3));
        innerPanel4.setOpaque(false);
        innerPanel4.add(new JLabel(MessageUtils.getLocalizedMessage("overview.label.num_top_terms")));
        innerPanel.add(innerPanel4);
        SpinnerNumberModel numberModel = new SpinnerNumberModel(50, 0, 1000, 1);
        this.numTopTermsSpnr.setPreferredSize(new Dimension(80, 30));
        this.numTopTermsSpnr.setModel(numberModel);
        JPanel innerPanel5 = new JPanel(new FlowLayout(3));
        innerPanel5.setOpaque(false);
        innerPanel5.add(this.numTopTermsSpnr);
        innerPanel.add(innerPanel5);
        JPanel termsPanel = new JPanel(new BorderLayout());
        termsPanel.setOpaque(false);
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("overview.label.top_terms"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        termsPanel.add((Component)label, "First");
        TableUtils.setupTable(this.topTermsTable, 0, new TopTermsTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OverviewPanelProvider.this.listeners.showTopTermsContextMenu(e);
            }
        }, TopTermsTableModel.Column.RANK.getColumnWidth(), TopTermsTableModel.Column.FREQ.getColumnWidth());
        JScrollPane scrollPane = new JScrollPane(this.topTermsTable);
        termsPanel.add((Component)scrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(1, selectedPanel, termsPanel);
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(180);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        panel.add(splitPane);
        return panel;
    }

    private void setUpTopTermsContextMenu() {
        JMenuItem item1 = new JMenuItem(MessageUtils.getLocalizedMessage("overview.toptermtable.menu.item1"));
        item1.addActionListener(this.listeners::browseByTerm);
        this.topTermsContextMenu.add(item1);
        JMenuItem item2 = new JMenuItem(MessageUtils.getLocalizedMessage("overview.toptermtable.menu.item2"));
        item2.addActionListener(this.listeners::searchByTerm);
        this.topTermsContextMenu.add(item2);
    }

    private void selectField() {
        String field = this.getSelectedField();
        this.selectedField.setText(field);
        this.showTopTermsBtn.setEnabled(true);
    }

    private void showTopTerms() {
        String field = this.getSelectedField();
        int numTerms = (Integer)this.numTopTermsSpnr.getModel().getValue();
        List<TermStats> termStats = this.overviewModel.getTopTerms(field, numTerms);
        this.topTermsTable.setModel(new TopTermsTableModel(termStats, numTerms));
        this.topTermsTable.getColumnModel().getColumn(TopTermsTableModel.Column.RANK.getIndex()).setMaxWidth(TopTermsTableModel.Column.RANK.getColumnWidth());
        this.topTermsTable.getColumnModel().getColumn(TopTermsTableModel.Column.FREQ.getIndex()).setMaxWidth(TopTermsTableModel.Column.FREQ.getColumnWidth());
        this.messageBroker.clearStatusMessage();
    }

    private void browseByTerm() {
        String field = this.getSelectedField();
        String term = this.getSelectedTerm();
        this.operatorRegistry.get(DocumentsTabOperator.class).ifPresent(operator -> {
            operator.browseTerm(field, term);
            this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.DOCUMENTS);
        });
    }

    private void searchByTerm() {
        String field = this.getSelectedField();
        String term = this.getSelectedTerm();
        this.operatorRegistry.get(SearchTabOperator.class).ifPresent(operator -> {
            operator.searchByTerm(field, term);
            this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.SEARCH);
        });
    }

    private String getSelectedField() {
        int selected = this.termCountsTable.getSelectedRow();
        int row = this.termCountsTable.convertRowIndexToModel(selected);
        if (row < 0 || row >= this.termCountsTable.getRowCount()) {
            throw new IllegalStateException("Field is not selected.");
        }
        return (String)this.termCountsTable.getModel().getValueAt(row, TermCountsTableModel.Column.NAME.getIndex());
    }

    private String getSelectedTerm() {
        int rowTerm = this.topTermsTable.getSelectedRow();
        if (rowTerm < 0 || rowTerm >= this.topTermsTable.getRowCount()) {
            throw new IllegalStateException("Term is not selected.");
        }
        return (String)this.topTermsTable.getModel().getValueAt(rowTerm, TopTermsTableModel.Column.TEXT.getIndex());
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void selectField(MouseEvent e) {
            OverviewPanelProvider.this.selectField();
        }

        void showTopTerms(ActionEvent e) {
            OverviewPanelProvider.this.showTopTerms();
        }

        void showTopTermsContextMenu(MouseEvent e) {
            if (e.getClickCount() == 2 && !e.isConsumed()) {
                int row = OverviewPanelProvider.this.topTermsTable.rowAtPoint(e.getPoint());
                if (row != OverviewPanelProvider.this.topTermsTable.getSelectedRow()) {
                    OverviewPanelProvider.this.topTermsTable.changeSelection(row, OverviewPanelProvider.this.topTermsTable.getSelectedColumn(), false, false);
                }
                OverviewPanelProvider.this.topTermsContextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        void browseByTerm(ActionEvent e) {
            OverviewPanelProvider.this.browseByTerm();
        }

        void searchByTerm(ActionEvent e) {
            OverviewPanelProvider.this.searchByTerm();
        }
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            OverviewPanelProvider.this.overviewModel = OverviewPanelProvider.this.overviewFactory.newInstance(state.getIndexReader(), state.getIndexPath());
            OverviewPanelProvider.this.indexPathLbl.setText(OverviewPanelProvider.this.overviewModel.getIndexPath());
            OverviewPanelProvider.this.indexPathLbl.setToolTipText(OverviewPanelProvider.this.overviewModel.getIndexPath());
            OverviewPanelProvider.this.numFieldsLbl.setText(Integer.toString(OverviewPanelProvider.this.overviewModel.getNumFields()));
            OverviewPanelProvider.this.numDocsLbl.setText(Integer.toString(OverviewPanelProvider.this.overviewModel.getNumDocuments()));
            OverviewPanelProvider.this.numTermsLbl.setText(Long.toString(OverviewPanelProvider.this.overviewModel.getNumTerms()));
            String del = OverviewPanelProvider.this.overviewModel.hasDeletions() ? String.format(Locale.ENGLISH, "Yes (%d)", OverviewPanelProvider.this.overviewModel.getNumDeletedDocs()) : "No";
            String opt = OverviewPanelProvider.this.overviewModel.isOptimized().map(b -> b != false ? "Yes" : "No").orElse("?");
            OverviewPanelProvider.this.delOptLbl.setText(del + " / " + opt);
            OverviewPanelProvider.this.indexVerLbl.setText(OverviewPanelProvider.this.overviewModel.getIndexVersion().map(v -> Long.toString(v)).orElse("?"));
            OverviewPanelProvider.this.indexFmtLbl.setText(OverviewPanelProvider.this.overviewModel.getIndexFormat().orElse(""));
            OverviewPanelProvider.this.dirImplLbl.setText(OverviewPanelProvider.this.overviewModel.getDirImpl().orElse(""));
            OverviewPanelProvider.this.commitPointLbl.setText(OverviewPanelProvider.this.overviewModel.getCommitDescription().orElse("---"));
            OverviewPanelProvider.this.commitUserDataLbl.setText(OverviewPanelProvider.this.overviewModel.getCommitUserData().orElse("---"));
            Map<String, Long> termCounts = OverviewPanelProvider.this.overviewModel.getSortedTermCounts(TermCountsOrder.COUNT_DESC);
            long numTerms = OverviewPanelProvider.this.overviewModel.getNumTerms();
            OverviewPanelProvider.this.termCountsTable.setModel(new TermCountsTableModel(numTerms, termCounts));
            OverviewPanelProvider.this.termCountsTable.setRowSorter(new TableRowSorter<TableModel>(OverviewPanelProvider.this.termCountsTable.getModel()));
            OverviewPanelProvider.this.termCountsTable.getColumnModel().getColumn(TermCountsTableModel.Column.NAME.getIndex()).setMaxWidth(TermCountsTableModel.Column.NAME.getColumnWidth());
            OverviewPanelProvider.this.termCountsTable.getColumnModel().getColumn(TermCountsTableModel.Column.TERM_COUNT.getIndex()).setMaxWidth(TermCountsTableModel.Column.TERM_COUNT.getColumnWidth());
            DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
            rightRenderer.setHorizontalAlignment(4);
            OverviewPanelProvider.this.termCountsTable.getColumnModel().getColumn(TermCountsTableModel.Column.RATIO.getIndex()).setCellRenderer(rightRenderer);
            OverviewPanelProvider.this.topTermsTable.setSelectionMode(0);
            OverviewPanelProvider.this.topTermsTable.getColumnModel().getColumn(TopTermsTableModel.Column.RANK.getIndex()).setMaxWidth(TopTermsTableModel.Column.RANK.getColumnWidth());
            OverviewPanelProvider.this.topTermsTable.getColumnModel().getColumn(TopTermsTableModel.Column.FREQ.getIndex()).setMaxWidth(TopTermsTableModel.Column.FREQ.getColumnWidth());
            OverviewPanelProvider.this.topTermsTable.getColumnModel().setColumnMargin(StyleConstants.TABLE_COLUMN_MARGIN_DEFAULT);
        }

        @Override
        public void closeIndex() {
            OverviewPanelProvider.this.indexPathLbl.setText("");
            OverviewPanelProvider.this.numFieldsLbl.setText("");
            OverviewPanelProvider.this.numDocsLbl.setText("");
            OverviewPanelProvider.this.numTermsLbl.setText("");
            OverviewPanelProvider.this.delOptLbl.setText("");
            OverviewPanelProvider.this.indexVerLbl.setText("");
            OverviewPanelProvider.this.indexFmtLbl.setText("");
            OverviewPanelProvider.this.dirImplLbl.setText("");
            OverviewPanelProvider.this.commitPointLbl.setText("");
            OverviewPanelProvider.this.commitUserDataLbl.setText("");
            OverviewPanelProvider.this.selectedField.setText("");
            OverviewPanelProvider.this.showTopTermsBtn.setEnabled(false);
            OverviewPanelProvider.this.termCountsTable.setRowSorter(null);
            OverviewPanelProvider.this.termCountsTable.setModel(new TermCountsTableModel());
            OverviewPanelProvider.this.topTermsTable.setModel(new TopTermsTableModel());
        }
    }

    static final class TermCountsTableModel
    extends TableModelBase<Column> {
        TermCountsTableModel() {
        }

        TermCountsTableModel(double numTerms, Map<String, Long> termCounts) {
            super(termCounts.size());
            int i = 0;
            for (Map.Entry<String, Long> e : termCounts.entrySet()) {
                String term = e.getKey();
                Long count = e.getValue();
                this.data[i++] = new Object[]{term, count, String.format(Locale.ENGLISH, "%.2f %%", (double)count.longValue() / numTerms * 100.0)};
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            NAME("Name", 0, String.class, 150),
            TERM_COUNT("Term count", 1, Long.class, 100),
            RATIO("%", 2, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    static final class TopTermsTableModel
    extends TableModelBase<Column> {
        TopTermsTableModel() {
        }

        TopTermsTableModel(List<TermStats> termStats, int numTerms) {
            super(Math.min(numTerms, termStats.size()));
            for (int i = 0; i < this.data.length; ++i) {
                int rank = i + 1;
                int freq = termStats.get(i).getDocFreq();
                String termText = termStats.get(i).getDecodedTermText();
                this.data[i] = new Object[]{rank, freq, termText};
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            RANK("Rank", 0, Integer.class, 50),
            FREQ("Freq", 1, Integer.class, 80),
            TEXT("Text", 2, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }
}

