/*
 * Decompiled with CFR 0.152.
 */
package lucli;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import jline.SimpleCompletor;
import lucli.LuceneMethods;
import org.apache.lucene.queryParser.ParseException;

public class Lucli {
    static final String DEFAULT_INDEX = "index";
    static final String HISTORYFILE = ".lucli";
    public static final int MAX_TERMS = 100;
    static final int NOCOMMAND = -2;
    static final int UNKOWN = -1;
    static final int INFO = 0;
    static final int SEARCH = 1;
    static final int OPTIMIZE = 2;
    static final int QUIT = 3;
    static final int HELP = 4;
    static final int COUNT = 5;
    static final int TERMS = 6;
    static final int INDEX = 7;
    static final int TOKENS = 8;
    static final int EXPLAIN = 9;
    String historyFile;
    TreeMap commandMap = new TreeMap();
    LuceneMethods luceneMethods;
    boolean enableReadline;

    public Lucli(String[] args) throws IOException {
        this.historyFile = System.getProperty("user.home") + File.separator + HISTORYFILE;
        this.addCommand("info", 0, "Display info about the current Lucene index. Example: info");
        this.addCommand("search", 1, "Search the current index. Example: search foo", 1);
        this.addCommand("count", 5, "Return the number of hits for a search. Example: count foo", 1);
        this.addCommand("optimize", 2, "Optimize the current index");
        this.addCommand("quit", 3, "Quit/exit the program");
        this.addCommand("help", 4, "Display help about commands");
        this.addCommand("terms", 6, "Show the first 100 terms in this index. Supply a field name to only show terms in a specific field. Example: terms");
        this.addCommand(DEFAULT_INDEX, 7, "Choose a different lucene index. Example index my_index", 1);
        this.addCommand("tokens", 8, "Does a search and shows the top 10 tokens for each document. Verbose! Example: tokens foo", 1);
        this.addCommand("explain", 9, "Explanation that describes how the document scored against query. Example: explain foo", 1);
        this.parseArgs(args);
        ConsoleReader cr = new ConsoleReader();
        cr.setHistory(new History(new File(this.historyFile)));
        Completor[] comp = new Completor[]{new SimpleCompletor(this.getCommandsAsArray()), new FileNameCompletor()};
        cr.addCompletor((Completor)new ArgumentCompletor(comp));
        this.luceneMethods = new LuceneMethods(DEFAULT_INDEX);
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = cr.readLine("lucli> ")) == null) {
                        continue;
                    }
                    this.handleCommand(line, cr);
                }
            }
            catch (EOFException eof) {
                System.out.println("");
                this.exit();
                continue;
            }
            catch (UnsupportedEncodingException enc) {
                enc.printStackTrace(System.err);
                continue;
            }
            catch (ParseException pe) {
                pe.printStackTrace(System.err);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    private String[] getCommandsAsArray() {
        Set commandSet = this.commandMap.keySet();
        String[] commands = new String[this.commandMap.size()];
        int i = 0;
        Iterator iter = commandSet.iterator();
        while (iter.hasNext()) {
            String cmd = (String)iter.next();
            commands[i++] = cmd;
        }
        return commands;
    }

    public static void main(String[] args) throws IOException {
        new Lucli(args);
    }

    private void handleCommand(String line, ConsoleReader cr) throws IOException, ParseException {
        String[] words = this.tokenizeCommand(line);
        if (words.length == 0) {
            return;
        }
        String query = "";
        if (line.trim().startsWith("#")) {
            return;
        }
        switch (this.getCommandId(words[0], words.length - 1)) {
            case 0: {
                this.luceneMethods.info();
                break;
            }
            case 1: {
                for (int ii = 1; ii < words.length; ++ii) {
                    query = query + words[ii] + " ";
                }
                this.luceneMethods.search(query, false, false, cr);
                break;
            }
            case 5: {
                for (int ii = 1; ii < words.length; ++ii) {
                    query = query + words[ii] + " ";
                }
                this.luceneMethods.count(query);
                break;
            }
            case 3: {
                this.exit();
                break;
            }
            case 6: {
                if (words.length > 1) {
                    this.luceneMethods.terms(words[1]);
                    break;
                }
                this.luceneMethods.terms(null);
                break;
            }
            case 7: {
                LuceneMethods newLm = new LuceneMethods(words[1]);
                try {
                    newLm.info();
                    this.luceneMethods = newLm;
                }
                catch (IOException ioe) {
                    this.error(ioe.toString());
                }
                break;
            }
            case 2: {
                this.luceneMethods.optimize();
                break;
            }
            case 8: {
                for (int ii = 1; ii < words.length; ++ii) {
                    query = query + words[ii] + " ";
                }
                this.luceneMethods.search(query, false, true, cr);
                break;
            }
            case 9: {
                for (int ii = 1; ii < words.length; ++ii) {
                    query = query + words[ii] + " ";
                }
                this.luceneMethods.search(query, true, false, cr);
                break;
            }
            case 4: {
                this.help();
                break;
            }
            case -2: {
                break;
            }
            case -1: {
                System.out.println("Unknown command: " + words[0] + ". Type help to get a list of commands.");
            }
        }
    }

    private String[] tokenizeCommand(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t");
        int size = tokenizer.countTokens();
        String[] tokens = new String[size];
        int ii = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[ii] = tokenizer.nextToken();
            ++ii;
        }
        return tokens;
    }

    private void exit() {
        System.exit(0);
    }

    private void addCommand(String name, int id, String help) {
        this.addCommand(name, id, help, 0);
    }

    private void addCommand(String name, int id, String help, int params) {
        Command command = new Command(name, id, help, params);
        this.commandMap.put(name, command);
    }

    private int getCommandId(String name, int params) {
        name.toLowerCase();
        Command command = (Command)this.commandMap.get(name);
        if (command == null) {
            return -1;
        }
        if (command.params > params) {
            this.error(command.name + " needs at least " + command.params + " arguments.");
            return -2;
        }
        return command.id;
    }

    private void help() {
        Iterator commands = this.commandMap.keySet().iterator();
        while (commands.hasNext()) {
            Command command = (Command)this.commandMap.get(commands.next());
            System.out.println("\t" + command.name + ": " + command.help);
        }
    }

    private void error(String message) {
        System.err.println("Error:" + message);
    }

    private void message(String text) {
        System.out.println(text);
    }

    private void parseArgs(String[] args) {
        if (args.length > 0) {
            this.usage();
            System.exit(1);
        }
    }

    private void usage() {
        this.message("Usage: lucli.Lucli");
        this.message("(currently, no parameters are supported)");
    }

    private class Command {
        String name;
        int id;
        int numberArgs;
        String help;
        int params;

        Command(String name, int id, String help, int params) {
            this.name = name;
            this.id = id;
            this.help = help;
            this.params = params;
        }

        public String commandUsage() {
            return this.name + ":" + this.help + ". Command takes " + this.params + " params";
        }
    }
}

