/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.ArrayUtil;

public class ToParentBlockJoinCollector
extends Collector {
    private final Sort sort;
    private final Map<Query, Integer> joinQueryID = new HashMap<Query, Integer>();
    private final int numParentHits;
    private final FieldValueHitQueue<OneGroup> queue;
    private final FieldComparator[] comparators;
    private final int[] reverseMul;
    private final int compEnd;
    private final boolean trackMaxScore;
    private final boolean trackScores;
    private int docBase;
    private ToParentBlockJoinQuery.BlockJoinScorer[] joinScorers = new ToParentBlockJoinQuery.BlockJoinScorer[0];
    private AtomicReaderContext currentReaderContext;
    private Scorer scorer;
    private boolean queueFull;
    private OneGroup bottom;
    private int totalHitCount;
    private float maxScore = Float.NaN;
    private OneGroup[] sortedGroups;

    public ToParentBlockJoinCollector(Sort sort, int numParentHits, boolean trackScores, boolean trackMaxScore) throws IOException {
        this.sort = sort;
        this.trackMaxScore = trackMaxScore;
        if (trackMaxScore) {
            this.maxScore = Float.MIN_VALUE;
        }
        this.trackScores = trackScores;
        this.numParentHits = numParentHits;
        this.queue = FieldValueHitQueue.create((SortField[])sort.getSort(), (int)numParentHits);
        this.comparators = this.queue.getComparators();
        this.reverseMul = this.queue.getReverseMul();
        this.compEnd = this.comparators.length - 1;
    }

    public void collect(int parentDoc) throws IOException {
        block11: {
            float score;
            block10: {
                ++this.totalHitCount;
                score = Float.NaN;
                if (this.trackMaxScore) {
                    score = this.scorer.score();
                    this.maxScore = Math.max(this.maxScore, score);
                }
                if (!this.queueFull) break block10;
                int i = 0;
                while (true) {
                    int c;
                    if ((c = this.reverseMul[i] * this.comparators[i].compareBottom(parentDoc)) < 0) {
                        return;
                    }
                    if (c > 0) break;
                    if (i == this.compEnd) {
                        return;
                    }
                    ++i;
                }
                for (i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].copy(this.bottom.slot, parentDoc);
                }
                if (!this.trackMaxScore && this.trackScores) {
                    score = this.scorer.score();
                }
                this.bottom.doc = this.docBase + parentDoc;
                this.bottom.readerContext = this.currentReaderContext;
                this.bottom.score = score;
                this.copyGroups(this.bottom);
                this.bottom = (OneGroup)((Object)this.queue.updateTop());
                for (i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].setBottom(this.bottom.slot);
                }
                break block11;
            }
            int comparatorSlot = this.totalHitCount - 1;
            for (int i = 0; i < this.comparators.length; ++i) {
                this.comparators[i].copy(comparatorSlot, parentDoc);
            }
            if (!this.trackMaxScore && this.trackScores) {
                score = this.scorer.score();
            }
            OneGroup og = new OneGroup(comparatorSlot, this.docBase + parentDoc, score, this.joinScorers.length, this.trackScores);
            og.readerContext = this.currentReaderContext;
            this.copyGroups(og);
            this.bottom = (OneGroup)((Object)this.queue.add((Object)og));
            boolean bl = this.queueFull = this.totalHitCount == this.numParentHits;
            if (!this.queueFull) break block11;
            for (int i = 0; i < this.comparators.length; ++i) {
                this.comparators[i].setBottom(this.bottom.slot);
            }
        }
    }

    private void copyGroups(OneGroup og) {
        int numSubScorers = this.joinScorers.length;
        if (og.docs.length < numSubScorers) {
            og.docs = ArrayUtil.grow((int[][])og.docs);
        }
        if (og.counts.length < numSubScorers) {
            og.counts = ArrayUtil.grow((int[])og.counts);
        }
        if (this.trackScores && og.scores.length < numSubScorers) {
            og.scores = ArrayUtil.grow((float[][])og.scores);
        }
        for (int scorerIDX = 0; scorerIDX < numSubScorers; ++scorerIDX) {
            ToParentBlockJoinQuery.BlockJoinScorer joinScorer = this.joinScorers[scorerIDX];
            if (joinScorer == null) continue;
            og.counts[scorerIDX] = joinScorer.getChildCount();
            og.docs[scorerIDX] = joinScorer.swapChildDocs(og.docs[scorerIDX]);
            if (!this.trackScores) continue;
            og.scores[scorerIDX] = joinScorer.swapChildScores(og.scores[scorerIDX]);
        }
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.currentReaderContext = context;
        this.docBase = context.docBase;
        for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
            this.queue.setComparator(compIDX, this.comparators[compIDX].setNextReader(context));
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    private void enroll(ToParentBlockJoinQuery query, ToParentBlockJoinQuery.BlockJoinScorer scorer) {
        Integer slot = this.joinQueryID.get((Object)query);
        if (slot == null) {
            this.joinQueryID.put(query, this.joinScorers.length);
            ToParentBlockJoinQuery.BlockJoinScorer[] newArray = new ToParentBlockJoinQuery.BlockJoinScorer[1 + this.joinScorers.length];
            System.arraycopy(this.joinScorers, 0, newArray, 0, this.joinScorers.length);
            this.joinScorers = newArray;
            this.joinScorers[this.joinScorers.length - 1] = scorer;
        } else {
            this.joinScorers[slot.intValue()] = scorer;
        }
    }

    public void setScorer(Scorer scorer) {
        this.scorer = new ScoreCachingWrappingScorer(scorer);
        for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
            this.comparators[compIDX].setScorer(this.scorer);
        }
        Arrays.fill((Object[])this.joinScorers, null);
        LinkedList<Scorer> queue = new LinkedList<Scorer>();
        queue.add(scorer);
        while ((scorer = (Scorer)queue.poll()) != null) {
            if (scorer instanceof ToParentBlockJoinQuery.BlockJoinScorer) {
                this.enroll((ToParentBlockJoinQuery)scorer.getWeight().getQuery(), (ToParentBlockJoinQuery.BlockJoinScorer)scorer);
            }
            for (Scorer.ChildScorer sub : scorer.getChildren()) {
                queue.add(sub.child);
            }
        }
    }

    private void sortQueue() {
        this.sortedGroups = new OneGroup[this.queue.size()];
        for (int downTo = this.queue.size() - 1; downTo >= 0; --downTo) {
            this.sortedGroups[downTo] = (OneGroup)((Object)this.queue.pop());
        }
    }

    public TopGroups<Integer> getTopGroups(ToParentBlockJoinQuery query, Sort withinGroupSort, int offset, int maxDocsPerGroup, int withinGroupOffset, boolean fillSortFields) throws IOException {
        Integer _slot = this.joinQueryID.get((Object)query);
        if (_slot == null) {
            if (this.totalHitCount == 0) {
                return null;
            }
            throw new IllegalArgumentException("the Query did not contain the provided BlockJoinQuery");
        }
        int slot = _slot;
        if (this.sortedGroups == null) {
            if (offset >= this.queue.size()) {
                return null;
            }
            this.sortQueue();
        } else if (offset > this.sortedGroups.length) {
            return null;
        }
        int totalGroupedHitCount = 0;
        FakeScorer fakeScorer = new FakeScorer();
        GroupDocs[] groups = new GroupDocs[this.sortedGroups.length - offset];
        for (int groupIDX = offset; groupIDX < this.sortedGroups.length; ++groupIDX) {
            Object[] groupSortValues;
            TopScoreDocCollector collector;
            OneGroup og = this.sortedGroups[groupIDX];
            if (withinGroupSort == null) {
                if (!this.trackScores) {
                    throw new IllegalArgumentException("cannot sort by relevance within group: trackScores=false");
                }
                collector = TopScoreDocCollector.create((int)maxDocsPerGroup, (boolean)true);
            } else {
                collector = TopFieldCollector.create((Sort)withinGroupSort, (int)maxDocsPerGroup, (boolean)fillSortFields, (boolean)this.trackScores, (boolean)this.trackMaxScore, (boolean)true);
            }
            collector.setScorer((Scorer)fakeScorer);
            collector.setNextReader(og.readerContext);
            int numChildDocs = og.counts[slot];
            for (int docIDX = 0; docIDX < numChildDocs; ++docIDX) {
                int doc;
                fakeScorer.doc = doc = og.docs[slot][docIDX];
                if (this.trackScores) {
                    fakeScorer.score = og.scores[slot][docIDX];
                }
                collector.collect(doc);
            }
            totalGroupedHitCount += numChildDocs;
            if (fillSortFields) {
                groupSortValues = new Object[this.comparators.length];
                for (int sortFieldIDX = 0; sortFieldIDX < this.comparators.length; ++sortFieldIDX) {
                    groupSortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(og.slot);
                }
            } else {
                groupSortValues = null;
            }
            TopDocs topDocs = collector.topDocs(withinGroupOffset, maxDocsPerGroup);
            groups[groupIDX - offset] = new GroupDocs(og.score, topDocs.getMaxScore(), og.counts[slot], topDocs.scoreDocs, (Object)og.doc, groupSortValues);
        }
        return new TopGroups(new TopGroups(this.sort.getSort(), withinGroupSort == null ? null : withinGroupSort.getSort(), 0, totalGroupedHitCount, groups, this.maxScore), Integer.valueOf(this.totalHitCount));
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    private static final class FakeScorer
    extends Scorer {
        float score;
        int doc;

        public FakeScorer() {
            super((Weight)null);
        }

        public float score() {
            return this.score;
        }

        public float freq() {
            return 1.0f;
        }

        public int docID() {
            return this.doc;
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class OneGroup
    extends FieldValueHitQueue.Entry {
        AtomicReaderContext readerContext;
        int[][] docs;
        float[][] scores;
        int[] counts;

        public OneGroup(int comparatorSlot, int parentDoc, float parentScore, int numJoins, boolean doScores) {
            super(comparatorSlot, parentDoc, parentScore);
            int joinID;
            this.docs = new int[numJoins][];
            for (joinID = 0; joinID < numJoins; ++joinID) {
                this.docs[joinID] = new int[5];
            }
            if (doScores) {
                this.scores = new float[numJoins][];
                for (joinID = 0; joinID < numJoins; ++joinID) {
                    this.scores[joinID] = new float[5];
                }
            }
            this.counts = new int[numJoins];
        }
    }
}

