/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TermsCollector
extends Collector {
    final String field;
    final Set<String> collectorTerms = new HashSet<String>();
    String[] fromDocTerms;

    TermsCollector(String field) {
        this.field = field;
    }

    public Set<String> getCollectorTerms() {
        return this.collectorTerms;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int doc) throws IOException {
        this.collectorTerms.add(this.fromDocTerms[doc]);
    }

    public void setNextReader(IndexReader indexReader, int docBase) throws IOException {
        this.fromDocTerms = FieldCache.DEFAULT.getStrings(indexReader, this.field);
    }
}

