/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.instantiated.InstantiatedDocument;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiatedTermFreqVector
implements TermFreqVector,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<InstantiatedTermDocumentInformation> termDocumentInformations;
    private final String field;
    private final String[] terms;
    private final int[] termFrequencies;

    public InstantiatedTermFreqVector(InstantiatedDocument document, String field) {
        this.field = field;
        this.termDocumentInformations = document.getVectorSpace().get(field);
        this.terms = new String[this.termDocumentInformations.size()];
        this.termFrequencies = new int[this.termDocumentInformations.size()];
        for (int i = 0; i < this.termDocumentInformations.size(); ++i) {
            InstantiatedTermDocumentInformation termDocumentInformation = this.termDocumentInformations.get(i);
            this.terms[i] = termDocumentInformation.getTerm().text();
            this.termFrequencies[i] = termDocumentInformation.getTermPositions().length;
        }
    }

    public String getField() {
        return this.field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(this.field).append(": ");
        if (this.terms != null) {
            for (int i = 0; i < this.terms.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.terms[i]).append('/').append(this.termFrequencies[i]);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.terms == null ? 0 : this.terms.length;
    }

    public String[] getTerms() {
        return this.terms;
    }

    public int[] getTermFrequencies() {
        return this.termFrequencies;
    }

    public int indexOf(String termText) {
        if (this.terms == null) {
            return -1;
        }
        int res = Arrays.binarySearch(this.terms, termText);
        return res >= 0 ? res : -1;
    }

    public int[] indexesOf(String[] termNumbers, int start, int len) {
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.indexOf(termNumbers[start + i]);
        }
        return res;
    }

    public List<InstantiatedTermDocumentInformation> getTermDocumentInformations() {
        return this.termDocumentInformations;
    }
}

