/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedTerm;

public class InstantiatedTermEnum
extends TermEnum {
    private final InstantiatedIndexReader reader;
    private int nextTermIndex;
    private InstantiatedTerm term;

    public InstantiatedTermEnum(InstantiatedIndexReader reader) {
        this.nextTermIndex = 0;
        this.reader = reader;
    }

    public InstantiatedTermEnum(InstantiatedIndexReader reader, int startPosition) {
        this.reader = reader;
        this.nextTermIndex = startPosition;
        this.next();
    }

    public boolean next() {
        if (this.reader.getIndex().getOrderedTerms().length <= this.nextTermIndex) {
            return false;
        }
        this.term = this.reader.getIndex().getOrderedTerms()[this.nextTermIndex];
        ++this.nextTermIndex;
        return true;
    }

    public Term term() {
        return this.term == null ? null : this.term.getTerm();
    }

    public int docFreq() {
        return this.term.getAssociatedDocuments().length;
    }

    public void close() {
    }
}

