/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;

public class InstantiatedTerm
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comparator<InstantiatedTerm> comparator = new Comparator<InstantiatedTerm>(){

        @Override
        public int compare(InstantiatedTerm instantiatedTerm, InstantiatedTerm instantiatedTerm1) {
            return instantiatedTerm.getTerm().compareTo(instantiatedTerm1.getTerm());
        }
    };
    public static final Comparator termComparator = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((InstantiatedTerm)o).getTerm().compareTo((Term)o1);
        }
    };
    private Term term;
    private int termIndex;
    private InstantiatedTermDocumentInformation[] associatedDocuments;

    public Term getTerm() {
        return this.term;
    }

    InstantiatedTerm(String field, String text) {
        this.term = new Term(field, text);
    }

    public InstantiatedTermDocumentInformation[] getAssociatedDocuments() {
        return this.associatedDocuments;
    }

    void setAssociatedDocuments(InstantiatedTermDocumentInformation[] associatedDocuments) {
        this.associatedDocuments = associatedDocuments;
    }

    public int seekCeilingDocumentInformationIndex(int target) {
        return this.seekCeilingDocumentInformationIndex(target, 0, this.getAssociatedDocuments().length);
    }

    public int seekCeilingDocumentInformationIndex(int target, int startOffset) {
        return this.seekCeilingDocumentInformationIndex(target, startOffset, this.getAssociatedDocuments().length);
    }

    public int seekCeilingDocumentInformationIndex(int target, int startOffset, int endPosition) {
        int pos = this.binarySearchAssociatedDocuments(target, startOffset, endPosition - startOffset);
        if (pos < 0) {
            pos = -1 - pos;
        }
        if (this.getAssociatedDocuments().length <= pos) {
            return -1;
        }
        return pos;
    }

    public int binarySearchAssociatedDocuments(int target) {
        return this.binarySearchAssociatedDocuments(target, 0);
    }

    public int binarySearchAssociatedDocuments(int target, int offset) {
        return this.binarySearchAssociatedDocuments(target, offset, this.associatedDocuments.length - offset);
    }

    public int binarySearchAssociatedDocuments(int target, int offset, int length) {
        if (length == 0) {
            return -1 - offset;
        }
        int min = offset;
        int max = offset + length - 1;
        int minVal = this.getAssociatedDocuments()[min].getDocument().getDocumentNumber();
        int maxVal = this.getAssociatedDocuments()[max].getDocument().getDocumentNumber();
        int nPreviousSteps = 0;
        while (target > minVal) {
            int pivot;
            if (target >= maxVal) {
                return target == maxVal ? max : -2 - max;
            }
            assert (min != max);
            if (nPreviousSteps > 2) {
                pivot = min + max >> 1;
            } else {
                pivot = min + (int)(((float)target - (float)minVal) / ((float)maxVal - (float)minVal) * (float)(max - min));
                ++nPreviousSteps;
            }
            int pivotVal = this.getAssociatedDocuments()[pivot].getDocument().getDocumentNumber();
            if (target > pivotVal) {
                min = pivot + 1;
                --max;
            } else {
                if (target == pivotVal) {
                    return pivot;
                }
                ++min;
                max = pivot - 1;
            }
            maxVal = this.getAssociatedDocuments()[max].getDocument().getDocumentNumber();
            minVal = this.getAssociatedDocuments()[min].getDocument().getDocumentNumber();
        }
        return target == minVal ? min : -1 - min;
    }

    public InstantiatedTermDocumentInformation getAssociatedDocument(int documentNumber) {
        int pos = this.binarySearchAssociatedDocuments(documentNumber);
        return pos < 0 ? null : this.getAssociatedDocuments()[pos];
    }

    public final String field() {
        return this.term.field();
    }

    public final String text() {
        return this.term.text();
    }

    public String toString() {
        return this.term.toString();
    }

    public int getTermIndex() {
        return this.termIndex;
    }

    public void setTermIndex(int termIndex) {
        this.termIndex = termIndex;
    }
}

