/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedTerm;

public class InstantiatedTermEnum
extends TermEnum {
    private final InstantiatedIndexReader reader;
    private int nextTermIndex;
    private InstantiatedTerm term;

    public InstantiatedTermEnum(InstantiatedIndexReader reader) {
        this.nextTermIndex = 0;
        this.reader = reader;
    }

    public InstantiatedTermEnum(InstantiatedIndexReader reader, int startPosition) {
        this.reader = reader;
        this.nextTermIndex = startPosition;
        this.next();
    }

    public boolean next() {
        if (this.reader.getIndex().getOrderedTerms().length <= this.nextTermIndex) {
            return false;
        }
        this.term = this.reader.getIndex().getOrderedTerms()[this.nextTermIndex];
        ++this.nextTermIndex;
        return true;
    }

    public Term term() {
        return this.term == null ? null : this.term.getTerm();
    }

    public int docFreq() {
        return this.term.getAssociatedDocuments().length;
    }

    public void close() {
    }

    public boolean skipTo(Term target) throws IOException {
        InstantiatedTerm term = this.reader.getIndex().findTerm(target);
        if (term != null) {
            this.term = term;
            this.nextTermIndex = term.getTermIndex() + 1;
            return true;
        }
        int pos = Arrays.binarySearch(this.reader.getIndex().getOrderedTerms(), target, InstantiatedTerm.termComparator);
        if (pos < 0) {
            pos = -1 - pos;
        }
        if (pos > this.reader.getIndex().getOrderedTerms().length) {
            return false;
        }
        this.term = this.reader.getIndex().getOrderedTerms()[pos];
        this.nextTermIndex = pos + 1;
        return true;
    }
}

