/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.instantiated.FieldSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldSettings {
    private Map<String, FieldSetting> fieldSettings = new HashMap<String, FieldSetting>();

    FieldSettings() {
    }

    synchronized FieldSetting merge(FieldSetting fieldSetting) {
        FieldSetting setting = this.fieldSettings.get(fieldSetting.fieldName);
        if (setting == null) {
            setting = new FieldSetting(fieldSetting.fieldName);
            this.fieldSettings.put(fieldSetting.fieldName, setting);
        }
        if (fieldSetting.stored) {
            setting.stored = true;
        }
        if (fieldSetting.compressed) {
            setting.compressed = true;
        }
        if ("b3".equals(fieldSetting.fieldName)) {
            System.currentTimeMillis();
        }
        if (fieldSetting.indexed) {
            setting.indexed = true;
        }
        if (fieldSetting.tokenized) {
            setting.tokenized = true;
        }
        if (fieldSetting.storeTermVector) {
            setting.storeTermVector = true;
        }
        if (fieldSetting.storeOffsetWithTermVector) {
            setting.storeOffsetWithTermVector = true;
        }
        if (fieldSetting.storePositionWithTermVector) {
            setting.storePositionWithTermVector = true;
        }
        if (fieldSetting.storePayloads) {
            setting.storePayloads = true;
        }
        return setting;
    }

    FieldSetting get(String name) {
        return this.fieldSettings.get(name);
    }

    FieldSetting get(String name, boolean create) {
        FieldSetting fieldSetting = this.fieldSettings.get(name);
        if (create && fieldSetting == null) {
            fieldSetting = new FieldSetting(name);
            this.fieldSettings.put(name, fieldSetting);
        }
        return fieldSetting;
    }

    Collection<FieldSetting> values() {
        return this.fieldSettings.values();
    }
}

