/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;

public class BlockGroupingCollector
extends Collector {
    private int[] pendingSubDocs;
    private float[] pendingSubScores;
    private int subDocUpto;
    private final Sort groupSort;
    private final int topNGroups;
    private final Filter lastDocPerGroup;
    private final boolean needsScores;
    private final FieldComparator<?>[] comparators;
    private final int[] reversed;
    private final int compIDXEnd;
    private int bottomSlot;
    private boolean queueFull;
    private AtomicReaderContext currentReaderContext;
    private int topGroupDoc;
    private int totalHitCount;
    private int totalGroupCount;
    private int docBase;
    private int groupEndDocID;
    private DocIdSetIterator lastDocPerGroupBits;
    private Scorer scorer;
    private final GroupQueue groupQueue;
    private boolean groupCompetes;

    private void processGroup() {
        ++this.totalGroupCount;
        if (this.groupCompetes) {
            if (!this.queueFull) {
                OneGroup og = new OneGroup();
                og.count = this.subDocUpto;
                og.topGroupDoc = this.docBase + this.topGroupDoc;
                og.docs = this.pendingSubDocs;
                this.pendingSubDocs = new int[10];
                if (this.needsScores) {
                    og.scores = this.pendingSubScores;
                    this.pendingSubScores = new float[10];
                }
                og.readerContext = this.currentReaderContext;
                og.comparatorSlot = this.bottomSlot;
                OneGroup bottomGroup = (OneGroup)this.groupQueue.add(og);
                boolean bl = this.queueFull = this.groupQueue.size() == this.topNGroups;
                if (this.queueFull) {
                    this.bottomSlot = bottomGroup.comparatorSlot;
                    for (int i = 0; i < this.comparators.length; ++i) {
                        this.comparators[i].setBottom(this.bottomSlot);
                    }
                } else {
                    this.bottomSlot = this.groupQueue.size();
                }
            } else {
                OneGroup og = (OneGroup)this.groupQueue.top();
                assert (og != null);
                og.count = this.subDocUpto;
                og.topGroupDoc = this.docBase + this.topGroupDoc;
                int[] savDocs = og.docs;
                og.docs = this.pendingSubDocs;
                this.pendingSubDocs = savDocs;
                if (this.needsScores) {
                    float[] savScores = og.scores;
                    og.scores = this.pendingSubScores;
                    this.pendingSubScores = savScores;
                }
                og.readerContext = this.currentReaderContext;
                this.bottomSlot = ((OneGroup)this.groupQueue.updateTop()).comparatorSlot;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].setBottom(this.bottomSlot);
                }
            }
        }
        this.subDocUpto = 0;
    }

    public BlockGroupingCollector(Sort groupSort, int topNGroups, boolean needsScores, Filter lastDocPerGroup) throws IOException {
        if (topNGroups < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + topNGroups + ")");
        }
        this.groupQueue = new GroupQueue(topNGroups);
        this.pendingSubDocs = new int[10];
        if (needsScores) {
            this.pendingSubScores = new float[10];
        }
        this.needsScores = needsScores;
        this.lastDocPerGroup = lastDocPerGroup;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
        SortField[] sortFields = groupSort.getSort();
        this.comparators = new FieldComparator[sortFields.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            this.comparators[i] = sortField.getComparator(topNGroups, i);
            this.reversed[i] = sortField.getReverse() ? -1 : 1;
        }
    }

    public TopGroups<?> getTopGroups(Sort withinGroupSort, int groupOffset, int withinGroupOffset, int maxDocsPerGroup, boolean fillSortFields) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        if (groupOffset >= this.groupQueue.size()) {
            return null;
        }
        int totalGroupedHitCount = 0;
        FakeScorer fakeScorer = new FakeScorer();
        float maxScore = Float.MIN_VALUE;
        GroupDocs[] groups = new GroupDocs[this.groupQueue.size() - groupOffset];
        for (int downTo = this.groupQueue.size() - groupOffset - 1; downTo >= 0; --downTo) {
            Object[] groupSortValues;
            TopScoreDocCollector collector;
            OneGroup og = (OneGroup)this.groupQueue.pop();
            if (withinGroupSort == null) {
                if (!this.needsScores) {
                    throw new IllegalArgumentException("cannot sort by relevance within group: needsScores=false");
                }
                collector = TopScoreDocCollector.create((int)maxDocsPerGroup, (boolean)true);
            } else {
                collector = TopFieldCollector.create((Sort)withinGroupSort, (int)maxDocsPerGroup, (boolean)fillSortFields, (boolean)this.needsScores, (boolean)this.needsScores, (boolean)true);
            }
            collector.setScorer((Scorer)fakeScorer);
            collector.setNextReader(og.readerContext);
            for (int docIDX = 0; docIDX < og.count; ++docIDX) {
                int doc;
                fakeScorer.doc = doc = og.docs[docIDX];
                if (this.needsScores) {
                    fakeScorer.score = og.scores[docIDX];
                }
                collector.collect(doc);
            }
            totalGroupedHitCount += og.count;
            if (fillSortFields) {
                groupSortValues = new Comparable[this.comparators.length];
                for (int sortFieldIDX = 0; sortFieldIDX < this.comparators.length; ++sortFieldIDX) {
                    groupSortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(og.comparatorSlot);
                }
            } else {
                groupSortValues = null;
            }
            TopDocs topDocs = collector.topDocs(withinGroupOffset, maxDocsPerGroup);
            groups[downTo] = new GroupDocs<Object>(Float.NaN, topDocs.getMaxScore(), og.count, topDocs.scoreDocs, null, groupSortValues);
            maxScore = Math.max(maxScore, topDocs.getMaxScore());
        }
        return new TopGroups(new TopGroups(this.groupSort.getSort(), withinGroupSort == null ? null : withinGroupSort.getSort(), this.totalHitCount, totalGroupedHitCount, groups, maxScore), this.totalGroupCount);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        for (FieldComparator<?> comparator : this.comparators) {
            comparator.setScorer(scorer);
        }
    }

    public void collect(int doc) throws IOException {
        if (doc > this.groupEndDocID) {
            if (this.subDocUpto != 0) {
                this.processGroup();
            }
            this.groupEndDocID = this.lastDocPerGroupBits.advance(doc);
            this.subDocUpto = 0;
            this.groupCompetes = !this.queueFull;
        }
        ++this.totalHitCount;
        if (this.subDocUpto == this.pendingSubDocs.length) {
            this.pendingSubDocs = ArrayUtil.grow((int[])this.pendingSubDocs);
        }
        this.pendingSubDocs[this.subDocUpto] = doc;
        if (this.needsScores) {
            if (this.subDocUpto == this.pendingSubScores.length) {
                this.pendingSubScores = ArrayUtil.grow((float[])this.pendingSubScores);
            }
            this.pendingSubScores[this.subDocUpto] = this.scorer.score();
        }
        ++this.subDocUpto;
        if (this.groupCompetes) {
            if (this.subDocUpto == 1) {
                assert (!this.queueFull);
                for (FieldComparator<?> fc : this.comparators) {
                    fc.copy(this.bottomSlot, doc);
                    fc.setBottom(this.bottomSlot);
                }
                this.topGroupDoc = doc;
            } else {
                int compIDX = 0;
                while (true) {
                    int c;
                    if ((c = this.reversed[compIDX] * this.comparators[compIDX].compareBottom(doc)) < 0) {
                        return;
                    }
                    if (c > 0) break;
                    if (compIDX == this.compIDXEnd) {
                        return;
                    }
                    ++compIDX;
                }
                for (FieldComparator<?> fc : this.comparators) {
                    fc.copy(this.bottomSlot, doc);
                    fc.setBottom(this.bottomSlot);
                }
                this.topGroupDoc = doc;
            }
        } else {
            int compIDX = 0;
            while (true) {
                int c;
                if ((c = this.reversed[compIDX] * this.comparators[compIDX].compareBottom(doc)) < 0) {
                    return;
                }
                if (c > 0) break;
                if (compIDX == this.compIDXEnd) {
                    return;
                }
                ++compIDX;
            }
            this.groupCompetes = true;
            for (FieldComparator<?> fc : this.comparators) {
                fc.copy(this.bottomSlot, doc);
                fc.setBottom(this.bottomSlot);
            }
            this.topGroupDoc = doc;
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        this.subDocUpto = 0;
        this.docBase = readerContext.docBase;
        this.lastDocPerGroupBits = this.lastDocPerGroup.getDocIdSet(readerContext, readerContext.reader().getLiveDocs()).iterator();
        this.groupEndDocID = -1;
        this.currentReaderContext = readerContext;
        for (int i = 0; i < this.comparators.length; ++i) {
            this.comparators[i] = this.comparators[i].setNextReader(readerContext);
        }
    }

    private final class GroupQueue
    extends PriorityQueue<OneGroup> {
        public GroupQueue(int size) {
            super(size);
        }

        protected boolean lessThan(OneGroup group1, OneGroup group2) {
            assert (group1 != group2);
            assert (group1.comparatorSlot != group2.comparatorSlot);
            int numComparators = BlockGroupingCollector.this.comparators.length;
            for (int compIDX = 0; compIDX < numComparators; ++compIDX) {
                int c = BlockGroupingCollector.this.reversed[compIDX] * BlockGroupingCollector.this.comparators[compIDX].compare(group1.comparatorSlot, group2.comparatorSlot);
                if (c == 0) continue;
                return c > 0;
            }
            return group1.topGroupDoc > group2.topGroupDoc;
        }
    }

    private static final class OneGroup {
        AtomicReaderContext readerContext;
        int topGroupDoc;
        int[] docs;
        float[] scores;
        int count;
        int comparatorSlot;

        private OneGroup() {
        }
    }

    private static final class FakeScorer
    extends Scorer {
        float score;
        int doc;

        public FakeScorer() {
            super((Weight)null);
        }

        public float score() {
            return this.score;
        }

        public int freq() {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            return this.doc;
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            return 1L;
        }
    }
}

