/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.SearchGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstPassGroupingCollector
extends Collector {
    private final String groupField;
    private final Sort groupSort;
    private final FieldComparator[] comparators;
    private final int[] reversed;
    private final int topNGroups;
    private final HashMap<String, CollectedSearchGroup> groupMap;
    private final int compIDXEnd;
    private TreeSet<CollectedSearchGroup> orderedGroups;
    private int docBase;
    private int spareSlot;
    private FieldCache.StringIndex index;

    public FirstPassGroupingCollector(String groupField, Sort groupSort, int topNGroups) throws IOException {
        if (topNGroups < 1) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + topNGroups + ")");
        }
        this.groupField = groupField;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
        SortField[] sortFields = groupSort.getSort();
        this.comparators = new FieldComparator[sortFields.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            this.comparators[i] = sortField.getComparator(topNGroups + 1, i);
            this.reversed[i] = sortField.getReverse() ? -1 : 1;
        }
        this.spareSlot = topNGroups;
        this.groupMap = new HashMap(topNGroups);
    }

    public Collection<SearchGroup> getTopGroups(int groupOffset, boolean fillFields) {
        if (groupOffset < 0) {
            throw new IllegalArgumentException("groupOffset must be >= 0 (got " + groupOffset + ")");
        }
        if (this.groupMap.size() <= groupOffset) {
            return null;
        }
        if (this.orderedGroups == null) {
            this.buildSortedSet();
        }
        ArrayList<SearchGroup> result = new ArrayList<SearchGroup>();
        int upto = 0;
        int sortFieldCount = this.groupSort.getSort().length;
        for (CollectedSearchGroup group : this.orderedGroups) {
            if (upto++ < groupOffset) continue;
            SearchGroup searchGroup = new SearchGroup();
            searchGroup.groupValue = group.groupValue;
            if (fillFields) {
                searchGroup.sortValues = new Comparable[sortFieldCount];
                for (int sortFieldIDX = 0; sortFieldIDX < sortFieldCount; ++sortFieldIDX) {
                    searchGroup.sortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(group.comparatorSlot);
                }
            }
            result.add(searchGroup);
        }
        return result;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setScorer(Scorer scorer) throws IOException {
        for (FieldComparator comparator : this.comparators) {
            comparator.setScorer(scorer);
        }
    }

    public void collect(int doc) throws IOException {
        CollectedSearchGroup prevLast;
        int ord;
        String br;
        CollectedSearchGroup group;
        if (this.orderedGroups != null) {
            int compIDX = 0;
            while (true) {
                int c;
                if ((c = this.reversed[compIDX] * this.comparators[compIDX].compareBottom(doc)) < 0) {
                    return;
                }
                if (c > 0) break;
                if (compIDX == this.compIDXEnd) {
                    return;
                }
                ++compIDX;
            }
        }
        if ((group = this.groupMap.get(br = this.index.lookup[ord = this.index.order[doc]])) == null) {
            if (this.groupMap.size() < this.topNGroups) {
                CollectedSearchGroup sg = new CollectedSearchGroup();
                sg.groupValue = br;
                sg.comparatorSlot = this.groupMap.size();
                sg.topDoc = this.docBase + doc;
                for (FieldComparator fc : this.comparators) {
                    fc.copy(sg.comparatorSlot, doc);
                }
                this.groupMap.put(sg.groupValue, sg);
                if (this.groupMap.size() == this.topNGroups) {
                    this.buildSortedSet();
                }
                return;
            }
            CollectedSearchGroup bottomGroup = this.orderedGroups.last();
            this.orderedGroups.remove(bottomGroup);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
            this.groupMap.remove(bottomGroup.groupValue);
            bottomGroup.groupValue = br;
            bottomGroup.topDoc = this.docBase + doc;
            for (FieldComparator fc : this.comparators) {
                fc.copy(bottomGroup.comparatorSlot, doc);
            }
            this.groupMap.put(bottomGroup.groupValue, bottomGroup);
            this.orderedGroups.add(bottomGroup);
            assert (this.orderedGroups.size() == this.topNGroups);
            int lastComparatorSlot = this.orderedGroups.last().comparatorSlot;
            for (FieldComparator fc : this.comparators) {
                fc.setBottom(lastComparatorSlot);
            }
            return;
        }
        int compIDX = 0;
        while (true) {
            FieldComparator fc = this.comparators[compIDX];
            fc.copy(this.spareSlot, doc);
            int c = this.reversed[compIDX] * fc.compare(group.comparatorSlot, this.spareSlot);
            if (c < 0) {
                return;
            }
            if (c > 0) {
                for (int compIDX2 = compIDX + 1; compIDX2 < this.comparators.length; ++compIDX2) {
                    this.comparators[compIDX2].copy(this.spareSlot, doc);
                }
                break;
            }
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        if (this.orderedGroups != null) {
            prevLast = this.orderedGroups.last();
            this.orderedGroups.remove(group);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
        } else {
            prevLast = null;
        }
        group.topDoc = this.docBase + doc;
        int tmp = this.spareSlot;
        this.spareSlot = group.comparatorSlot;
        group.comparatorSlot = tmp;
        if (this.orderedGroups != null) {
            this.orderedGroups.add(group);
            assert (this.orderedGroups.size() == this.topNGroups);
            CollectedSearchGroup newLast = this.orderedGroups.last();
            if (group == newLast || prevLast != newLast) {
                for (FieldComparator fc : this.comparators) {
                    fc.setBottom(newLast.comparatorSlot);
                }
            }
        }
    }

    private void buildSortedSet() {
        Comparator<CollectedSearchGroup> comparator = new Comparator<CollectedSearchGroup>(){

            @Override
            public int compare(CollectedSearchGroup o1, CollectedSearchGroup o2) {
                int compIDX = 0;
                while (true) {
                    FieldComparator fc = FirstPassGroupingCollector.this.comparators[compIDX];
                    int c = FirstPassGroupingCollector.this.reversed[compIDX] * fc.compare(o1.comparatorSlot, o2.comparatorSlot);
                    if (c != 0) {
                        return c;
                    }
                    if (compIDX == FirstPassGroupingCollector.this.compIDXEnd) {
                        return o1.topDoc - o2.topDoc;
                    }
                    ++compIDX;
                }
            }
        };
        this.orderedGroups = new TreeSet<CollectedSearchGroup>(comparator);
        this.orderedGroups.addAll(this.groupMap.values());
        assert (this.orderedGroups.size() > 0);
        for (FieldComparator fc : this.comparators) {
            fc.setBottom(this.orderedGroups.last().comparatorSlot);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        for (int i = 0; i < this.comparators.length; ++i) {
            this.comparators[i].setNextReader(reader, docBase);
        }
    }
}

