/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.facetset.DimRange;
import org.apache.lucene.facet.facetset.ExactFacetSetMatcher;
import org.apache.lucene.facet.facetset.FacetSet;
import org.apache.lucene.facet.facetset.FacetSetMatcher;
import org.apache.lucene.facet.facetset.FacetSetsField;
import org.apache.lucene.facet.facetset.MatchingFacetSetsCounts;
import org.apache.lucene.facet.facetset.RangeFacetSetMatcher;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class CustomFacetSetExample {
    private static final long MAY_SECOND_2022 = CustomFacetSetExample.date("2022-05-02");
    private static final long JUNE_SECOND_2022 = CustomFacetSetExample.date("2022-06-02");
    private static final long JULY_SECOND_2022 = CustomFacetSetExample.date("2022-07-02");
    private static final float HUNDRED_TWENTY_DEGREES = CustomFacetSetExample.fahrenheitToCelsius(120);
    private static final float HUNDRED_DEGREES = CustomFacetSetExample.fahrenheitToCelsius(100);
    private static final float EIGHTY_DEGREES = CustomFacetSetExample.fahrenheitToCelsius(80);
    private final Directory indexDir = new ByteBuffersDirectory();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        Document doc = new Document();
        doc.add((IndexableField)new StringField("city", "city1", Field.Store.YES));
        doc.add((IndexableField)FacetSetsField.create((String)"temperature", (FacetSet[])new FacetSet[]{new TemperatureReadingFacetSet(MAY_SECOND_2022, HUNDRED_DEGREES), new TemperatureReadingFacetSet(JUNE_SECOND_2022, EIGHTY_DEGREES), new TemperatureReadingFacetSet(JULY_SECOND_2022, HUNDRED_TWENTY_DEGREES)}));
        this.addFastMatchFields(doc);
        indexWriter.addDocument((Iterable)doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("city", "city2", Field.Store.YES));
        doc.add((IndexableField)FacetSetsField.create((String)"temperature", (FacetSet[])new FacetSet[]{new TemperatureReadingFacetSet(MAY_SECOND_2022, EIGHTY_DEGREES), new TemperatureReadingFacetSet(JUNE_SECOND_2022, HUNDRED_DEGREES), new TemperatureReadingFacetSet(JULY_SECOND_2022, HUNDRED_TWENTY_DEGREES)}));
        this.addFastMatchFields(doc);
        indexWriter.addDocument((Iterable)doc);
        indexWriter.close();
    }

    private void addFastMatchFields(Document doc) {
        doc.add((IndexableField)new StringField("day", String.valueOf(MAY_SECOND_2022), Field.Store.NO));
        doc.add((IndexableField)new StringField("day", String.valueOf(JUNE_SECOND_2022), Field.Store.NO));
        doc.add((IndexableField)new StringField("day", String.valueOf(JULY_SECOND_2022), Field.Store.NO));
        doc.add((IndexableField)new StringField("temp", String.valueOf(EIGHTY_DEGREES), Field.Store.NO));
        doc.add((IndexableField)new StringField("temp", String.valueOf(HUNDRED_DEGREES), Field.Store.NO));
        doc.add((IndexableField)new StringField("temp", String.valueOf(HUNDRED_TWENTY_DEGREES), Field.Store.NO));
    }

    private FacetResult exactMatching() throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            FacetsCollector fc = (FacetsCollector)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new FacetsCollectorManager());
            MatchingFacetSetsCounts facets = new MatchingFacetSetsCounts("temperature", fc, TemperatureReadingFacetSet::decodeTemperatureReading, new FacetSetMatcher[]{new ExactFacetSetMatcher("May 2022 (100f)", (FacetSet)new TemperatureReadingFacetSet(MAY_SECOND_2022, HUNDRED_DEGREES)), new ExactFacetSetMatcher("July 2022 (120f)", (FacetSet)new TemperatureReadingFacetSet(JULY_SECOND_2022, HUNDRED_TWENTY_DEGREES))});
            FacetResult facetResult = facets.getAllChildren("temperature", new String[0]);
            return facetResult;
        }
    }

    private FacetResult exactMatchingWithFastMatchQuery() throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            FacetsCollector fc = (FacetsCollector)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new FacetsCollectorManager());
            TermInSetQuery dateQuery = new TermInSetQuery("day", Arrays.asList(new BytesRef((CharSequence)String.valueOf(MAY_SECOND_2022)), new BytesRef((CharSequence)String.valueOf(JULY_SECOND_2022))));
            TermInSetQuery temperatureQuery = new TermInSetQuery("temp", Arrays.asList(new BytesRef((CharSequence)String.valueOf(HUNDRED_DEGREES)), new BytesRef((CharSequence)String.valueOf(HUNDRED_TWENTY_DEGREES))));
            BooleanQuery fastMatchQuery = new BooleanQuery.Builder().add((Query)dateQuery, BooleanClause.Occur.MUST).add((Query)temperatureQuery, BooleanClause.Occur.MUST).build();
            MatchingFacetSetsCounts facets = new MatchingFacetSetsCounts("temperature", fc, TemperatureReadingFacetSet::decodeTemperatureReading, (Query)fastMatchQuery, new FacetSetMatcher[]{new ExactFacetSetMatcher("May 2022 (100f)", (FacetSet)new TemperatureReadingFacetSet(MAY_SECOND_2022, HUNDRED_DEGREES)), new ExactFacetSetMatcher("July 2022 (120f)", (FacetSet)new TemperatureReadingFacetSet(JULY_SECOND_2022, HUNDRED_TWENTY_DEGREES))});
            FacetResult facetResult = facets.getAllChildren("temperature", new String[0]);
            return facetResult;
        }
    }

    private FacetResult rangeMatching() throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            FacetsCollector fc = (FacetsCollector)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new FacetsCollectorManager());
            MatchingFacetSetsCounts facets = new MatchingFacetSetsCounts("temperature", fc, TemperatureReadingFacetSet::decodeTemperatureReading, new FacetSetMatcher[]{new RangeFacetSetMatcher("Eighty to Hundred Degrees", new DimRange[]{DimRange.fromLongs((long)Long.MIN_VALUE, (boolean)true, (long)Long.MAX_VALUE, (boolean)true), DimRange.fromFloats((float)EIGHTY_DEGREES, (boolean)true, (float)HUNDRED_DEGREES, (boolean)true)})});
            FacetResult facetResult = facets.getAllChildren("temperature", new String[0]);
            return facetResult;
        }
    }

    private FacetResult customRangeMatching() throws IOException {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            FacetsCollector fc = (FacetsCollector)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new FacetsCollectorManager());
            MatchingFacetSetsCounts facets = new MatchingFacetSetsCounts("temperature", fc, TemperatureReadingFacetSet::decodeTemperatureReading, new FacetSetMatcher[]{new TemperatureOnlyFacetSetMatcher("Eighty to Hundred Degrees", DimRange.fromFloats((float)EIGHTY_DEGREES, (boolean)true, (float)HUNDRED_DEGREES, (boolean)true))});
            FacetResult facetResult = facets.getAllChildren("temperature", new String[0]);
            return facetResult;
        }
    }

    private static long date(String dateString) {
        return LocalDate.parse(dateString).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private static float fahrenheitToCelsius(int degrees) {
        return ((float)degrees - 32.0f) * 5.0f / 9.0f;
    }

    public FacetResult runExactMatching() throws IOException {
        this.index();
        return this.exactMatching();
    }

    public FacetResult runExactMatchingWithFastMatchQuery() throws IOException {
        this.index();
        return this.exactMatchingWithFastMatchQuery();
    }

    public FacetResult runRangeMatching() throws IOException {
        this.index();
        return this.rangeMatching();
    }

    public FacetResult runCustomRangeMatching() throws IOException {
        this.index();
        return this.customRangeMatching();
    }

    public static void main(String[] args) throws Exception {
        CustomFacetSetExample example = new CustomFacetSetExample();
        System.out.println("Exact Facet Set matching example:");
        System.out.println("-----------------------");
        FacetResult result = example.runExactMatching();
        System.out.println("Temperature Reading: " + result);
        System.out.println("Exact Facet Set matching with fast match query example:");
        System.out.println("-----------------------");
        result = example.runExactMatchingWithFastMatchQuery();
        System.out.println("Temperature Reading: " + result);
        System.out.println("Range Facet Set matching example:");
        System.out.println("-----------------------");
        result = example.runRangeMatching();
        System.out.println("Temperature Reading: " + result);
        System.out.println("Custom Range Facet Set matching example:");
        System.out.println("-----------------------");
        result = example.runCustomRangeMatching();
        System.out.println("Temperature Reading: " + result);
    }

    public static class TemperatureOnlyFacetSetMatcher
    extends FacetSetMatcher {
        private final DimRange temperatureRange;

        protected TemperatureOnlyFacetSetMatcher(String label, DimRange temperatureRange) {
            super(label, 1);
            this.temperatureRange = temperatureRange;
        }

        public boolean matches(long[] dimValues) {
            return this.temperatureRange.min <= dimValues[1] && this.temperatureRange.max >= dimValues[1];
        }
    }

    public static class TemperatureReadingFacetSet
    extends FacetSet {
        private static final int SIZE_PACKED_BYTES = 12;
        private final long date;
        private final float degrees;

        public TemperatureReadingFacetSet(long date, float degrees) {
            super(2);
            this.date = date;
            this.degrees = degrees;
        }

        public long[] getComparableValues() {
            return new long[]{this.date, NumericUtils.floatToSortableInt((float)this.degrees)};
        }

        public int packValues(byte[] buf, int start) {
            LongPoint.encodeDimension((long)this.date, (byte[])buf, (int)start);
            FloatPoint.encodeDimension((float)this.degrees, (byte[])buf, (int)(start + 8));
            return this.sizePackedBytes();
        }

        public int sizePackedBytes() {
            return 12;
        }

        public static int decodeTemperatureReading(BytesRef bytesRef, int start, long[] dest) {
            dest[0] = LongPoint.decodeDimension((byte[])bytesRef.bytes, (int)start);
            dest[1] = IntPoint.decodeDimension((byte[])bytesRef.bytes, (int)(start + 8));
            return 12;
        }
    }
}

