/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public final class MemoryPostingsFormat
extends PostingsFormat {
    private final boolean doPackFST;
    private final float acceptableOverheadRatio;
    private static String EXTENSION = "ram";

    public MemoryPostingsFormat() {
        this(false, 0.2f);
    }

    public MemoryPostingsFormat(boolean doPackFST, float acceptableOverheadRatio) {
        super("Memory");
        this.doPackFST = doPackFST;
        this.acceptableOverheadRatio = acceptableOverheadRatio;
    }

    public String toString() {
        return "PostingsFormat(name=" + this.getName() + " doPackFST= " + this.doPackFST + ")";
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)EXTENSION);
        final IndexOutput out = state.directory.createOutput(fileName, state.context);
        return new FieldsConsumer(){

            public TermsConsumer addField(FieldInfo field) {
                return new TermsWriter(out, field, MemoryPostingsFormat.this.doPackFST, MemoryPostingsFormat.this.acceptableOverheadRatio);
            }

            public void close() throws IOException {
                try {
                    out.writeVInt(0);
                }
                finally {
                    out.close();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)EXTENSION);
        final TreeMap<String, TermsReader> fields = new TreeMap<String, TermsReader>();
        try (IndexInput in = state.directory.openInput(fileName, IOContext.READONCE);){
            int termCount;
            while ((termCount = in.readVInt()) != 0) {
                TermsReader termsReader = new TermsReader(state.fieldInfos, in, termCount);
                fields.put(((TermsReader)termsReader).field.name, termsReader);
            }
        }
        return new FieldsProducer(){

            public Iterator<String> iterator() {
                return Collections.unmodifiableSet(fields.keySet()).iterator();
            }

            public Terms terms(String field) {
                return (Terms)fields.get(field);
            }

            public int size() {
                return fields.size();
            }

            public void close() {
                for (TermsReader termsReader : fields.values()) {
                    termsReader.fst = null;
                }
            }
        };
    }

    private static final class TermsReader
    extends Terms {
        private final long sumTotalTermFreq;
        private final long sumDocFreq;
        private final int docCount;
        private final int termCount;
        private FST<BytesRef> fst;
        private final ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
        private final FieldInfo field;

        public TermsReader(FieldInfos fieldInfos, IndexInput in, int termCount) throws IOException {
            this.termCount = termCount;
            int fieldNumber = in.readVInt();
            this.field = fieldInfos.fieldInfo(fieldNumber);
            this.sumTotalTermFreq = this.field.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY ? in.readVLong() : -1L;
            this.sumDocFreq = in.readVLong();
            this.docCount = in.readVInt();
            this.fst = new FST((DataInput)in, (Outputs)this.outputs);
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public int getDocCount() {
            return this.docCount;
        }

        public long size() {
            return this.termCount;
        }

        public TermsEnum iterator(TermsEnum reuse) {
            return new FSTTermsEnum(this.field, this.fst);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public boolean hasOffsets() {
            return this.field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.field.hasPayloads();
        }
    }

    private static final class FSTTermsEnum
    extends TermsEnum {
        private final FieldInfo field;
        private final BytesRefFSTEnum<BytesRef> fstEnum;
        private final ByteArrayDataInput buffer = new ByteArrayDataInput();
        private boolean didDecode;
        private int docFreq;
        private long totalTermFreq;
        private BytesRefFSTEnum.InputOutput<BytesRef> current;

        public FSTTermsEnum(FieldInfo field, FST<BytesRef> fst) {
            this.field = field;
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        private void decodeMetaData() {
            if (!this.didDecode) {
                this.buffer.reset(((BytesRef)this.current.output).bytes, 0, ((BytesRef)this.current.output).length);
                this.docFreq = this.buffer.readVInt();
                this.totalTermFreq = this.field.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY ? (long)this.docFreq + this.buffer.readVLong() : -1L;
                ((BytesRef)this.current.output).offset = this.buffer.getPosition();
                this.didDecode = true;
            }
        }

        public boolean seekExact(BytesRef text, boolean useCache) throws IOException {
            this.current = this.fstEnum.seekExact(text);
            this.didDecode = false;
            return this.current != null;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) throws IOException {
            this.current = this.fstEnum.seekCeil(text);
            if (this.current == null) {
                return TermsEnum.SeekStatus.END;
            }
            this.didDecode = false;
            if (text.equals((Object)this.current.input)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) {
            FSTDocsEnum docsEnum;
            this.decodeMetaData();
            if (reuse == null || !(reuse instanceof FSTDocsEnum)) {
                docsEnum = new FSTDocsEnum(this.field.getIndexOptions(), this.field.hasPayloads());
            } else {
                docsEnum = (FSTDocsEnum)reuse;
                if (!docsEnum.canReuse(this.field.getIndexOptions(), this.field.hasPayloads())) {
                    docsEnum = new FSTDocsEnum(this.field.getIndexOptions(), this.field.hasPayloads());
                }
            }
            return docsEnum.reset((BytesRef)this.current.output, liveDocs, this.docFreq);
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) {
            FSTDocsAndPositionsEnum docsAndPositionsEnum;
            boolean hasOffsets;
            boolean bl = hasOffsets = this.field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (this.field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                return null;
            }
            this.decodeMetaData();
            if (reuse == null || !(reuse instanceof FSTDocsAndPositionsEnum)) {
                docsAndPositionsEnum = new FSTDocsAndPositionsEnum(this.field.hasPayloads(), hasOffsets);
            } else {
                docsAndPositionsEnum = (FSTDocsAndPositionsEnum)reuse;
                if (!docsAndPositionsEnum.canReuse(this.field.hasPayloads(), hasOffsets)) {
                    docsAndPositionsEnum = new FSTDocsAndPositionsEnum(this.field.hasPayloads(), hasOffsets);
                }
            }
            return docsAndPositionsEnum.reset((BytesRef)this.current.output, liveDocs, this.docFreq);
        }

        public BytesRef term() {
            return this.current.input;
        }

        public BytesRef next() throws IOException {
            this.current = this.fstEnum.next();
            if (this.current == null) {
                return null;
            }
            this.didDecode = false;
            return this.current.input;
        }

        public int docFreq() {
            this.decodeMetaData();
            return this.docFreq;
        }

        public long totalTermFreq() {
            this.decodeMetaData();
            return this.totalTermFreq;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public long ord() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FSTDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private final boolean storePayloads;
        private byte[] buffer = new byte[16];
        private final ByteArrayDataInput in = new ByteArrayDataInput(this.buffer);
        private Bits liveDocs;
        private int docUpto;
        private int docID = -1;
        private int accum;
        private int freq;
        private int numDocs;
        private int posPending;
        private int payloadLength;
        final boolean storeOffsets;
        int offsetLength;
        int startOffset;
        private int pos;
        private final BytesRef payload = new BytesRef();

        public FSTDocsAndPositionsEnum(boolean storePayloads, boolean storeOffsets) {
            this.storePayloads = storePayloads;
            this.storeOffsets = storeOffsets;
        }

        public boolean canReuse(boolean storePayloads, boolean storeOffsets) {
            return storePayloads == this.storePayloads && storeOffsets == this.storeOffsets;
        }

        public FSTDocsAndPositionsEnum reset(BytesRef bufferIn, Bits liveDocs, int numDocs) {
            assert (numDocs > 0);
            if (this.buffer.length < bufferIn.length - bufferIn.offset) {
                this.buffer = ArrayUtil.grow((byte[])this.buffer, (int)(bufferIn.length - bufferIn.offset));
            }
            this.in.reset(this.buffer, 0, bufferIn.length - bufferIn.offset);
            System.arraycopy(bufferIn.bytes, bufferIn.offset, this.buffer, 0, bufferIn.length - bufferIn.offset);
            this.liveDocs = liveDocs;
            this.docID = -1;
            this.accum = 0;
            this.docUpto = 0;
            this.payload.bytes = this.buffer;
            this.payloadLength = 0;
            this.numDocs = numDocs;
            this.posPending = 0;
            this.startOffset = this.storeOffsets ? 0 : -1;
            this.offsetLength = 0;
            return this;
        }

        public int nextDoc() {
            while (this.posPending > 0) {
                this.nextPosition();
            }
            block1: while (true) {
                if (this.docUpto == this.numDocs) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.docUpto;
                int code = this.in.readVInt();
                this.accum += code >>> 1;
                if ((code & 1) != 0) {
                    this.freq = 1;
                } else {
                    this.freq = this.in.readVInt();
                    assert (this.freq > 0);
                }
                if (this.liveDocs == null || this.liveDocs.get(this.accum)) {
                    this.pos = 0;
                    this.startOffset = this.storeOffsets ? 0 : -1;
                    this.posPending = this.freq;
                    this.docID = this.accum;
                    return this.docID;
                }
                int posUpto = 0;
                while (true) {
                    if (posUpto >= this.freq) continue block1;
                    if (!this.storePayloads) {
                        this.in.readVInt();
                    } else {
                        int skipCode = this.in.readVInt();
                        if ((skipCode & 1) != 0) {
                            this.payloadLength = this.in.readVInt();
                        }
                    }
                    if (this.storeOffsets && (this.in.readVInt() & 1) != 0) {
                        this.offsetLength = this.in.readVInt();
                    }
                    if (this.storePayloads) {
                        this.in.skipBytes(this.payloadLength);
                    }
                    ++posUpto;
                }
                break;
            }
        }

        public int nextPosition() {
            assert (this.posPending > 0);
            --this.posPending;
            if (!this.storePayloads) {
                this.pos += this.in.readVInt();
            } else {
                int code = this.in.readVInt();
                this.pos += code >>> 1;
                if ((code & 1) != 0) {
                    this.payloadLength = this.in.readVInt();
                }
            }
            if (this.storeOffsets) {
                int offsetCode = this.in.readVInt();
                if ((offsetCode & 1) != 0) {
                    this.offsetLength = this.in.readVInt();
                }
                this.startOffset += offsetCode >>> 1;
            }
            if (this.storePayloads) {
                this.payload.offset = this.in.getPosition();
                this.in.skipBytes(this.payloadLength);
                this.payload.length = this.payloadLength;
            }
            return this.pos;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.startOffset + this.offsetLength;
        }

        public BytesRef getPayload() {
            return this.payload.length > 0 ? this.payload : null;
        }

        public int docID() {
            return this.docID;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public int freq() {
            return this.freq;
        }

        public long cost() {
            return this.numDocs;
        }
    }

    private static final class FSTDocsEnum
    extends DocsEnum {
        private final FieldInfo.IndexOptions indexOptions;
        private final boolean storePayloads;
        private byte[] buffer = new byte[16];
        private final ByteArrayDataInput in = new ByteArrayDataInput(this.buffer);
        private Bits liveDocs;
        private int docUpto;
        private int docID = -1;
        private int accum;
        private int freq;
        private int payloadLen;
        private int numDocs;

        public FSTDocsEnum(FieldInfo.IndexOptions indexOptions, boolean storePayloads) {
            this.indexOptions = indexOptions;
            this.storePayloads = storePayloads;
        }

        public boolean canReuse(FieldInfo.IndexOptions indexOptions, boolean storePayloads) {
            return indexOptions == this.indexOptions && storePayloads == this.storePayloads;
        }

        public FSTDocsEnum reset(BytesRef bufferIn, Bits liveDocs, int numDocs) {
            assert (numDocs > 0);
            if (this.buffer.length < bufferIn.length - bufferIn.offset) {
                this.buffer = ArrayUtil.grow((byte[])this.buffer, (int)(bufferIn.length - bufferIn.offset));
            }
            this.in.reset(this.buffer, 0, bufferIn.length - bufferIn.offset);
            System.arraycopy(bufferIn.bytes, bufferIn.offset, this.buffer, 0, bufferIn.length - bufferIn.offset);
            this.liveDocs = liveDocs;
            this.docID = -1;
            this.accum = 0;
            this.docUpto = 0;
            this.freq = 1;
            this.payloadLen = 0;
            this.numDocs = numDocs;
            return this;
        }

        public int nextDoc() {
            do {
                int posCode;
                int posUpto;
                if (this.docUpto == this.numDocs) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.docUpto;
                if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.accum += this.in.readVInt();
                    continue;
                }
                int code = this.in.readVInt();
                this.accum += code >>> 1;
                if ((code & 1) != 0) {
                    this.freq = 1;
                } else {
                    this.freq = this.in.readVInt();
                    assert (this.freq > 0);
                }
                if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                    for (posUpto = 0; posUpto < this.freq; ++posUpto) {
                        if (!this.storePayloads) {
                            this.in.readVInt();
                            continue;
                        }
                        posCode = this.in.readVInt();
                        if ((posCode & 1) != 0) {
                            this.payloadLen = this.in.readVInt();
                        }
                        this.in.skipBytes(this.payloadLen);
                    }
                } else {
                    if (this.indexOptions != FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) continue;
                    for (posUpto = 0; posUpto < this.freq; ++posUpto) {
                        posCode = this.in.readVInt();
                        if (this.storePayloads && (posCode & 1) != 0) {
                            this.payloadLen = this.in.readVInt();
                        }
                        if ((this.in.readVInt() & 1) != 0) {
                            this.in.readVInt();
                        }
                        if (!this.storePayloads) continue;
                        this.in.skipBytes(this.payloadLen);
                    }
                }
            } while (this.liveDocs != null && !this.liveDocs.get(this.accum));
            this.docID = this.accum;
            return this.docID;
        }

        public int docID() {
            return this.docID;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public int freq() {
            return this.freq;
        }

        public long cost() {
            return this.numDocs;
        }
    }

    private static final class TermsWriter
    extends TermsConsumer {
        private final IndexOutput out;
        private final FieldInfo field;
        private final Builder<BytesRef> builder;
        private final ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
        private final boolean doPackFST;
        private final float acceptableOverheadRatio;
        private int termCount;
        private final PostingsWriter postingsWriter = new PostingsWriter();
        private final RAMOutputStream buffer2 = new RAMOutputStream();
        private final BytesRef spare = new BytesRef();
        private byte[] finalBuffer = new byte[128];
        private final IntsRef scratchIntsRef = new IntsRef();

        public TermsWriter(IndexOutput out, FieldInfo field, boolean doPackFST, float acceptableOverheadRatio) {
            this.out = out;
            this.field = field;
            this.doPackFST = doPackFST;
            this.acceptableOverheadRatio = acceptableOverheadRatio;
            this.builder = new Builder(FST.INPUT_TYPE.BYTE1, 0, 0, true, true, Integer.MAX_VALUE, (Outputs)this.outputs, null, doPackFST, acceptableOverheadRatio, true, 15);
        }

        public PostingsConsumer startTerm(BytesRef text) {
            return this.postingsWriter.reset();
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            assert (this.postingsWriter.docCount == stats.docFreq);
            assert (this.buffer2.getFilePointer() == 0L);
            this.buffer2.writeVInt(stats.docFreq);
            if (this.field.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                this.buffer2.writeVLong(stats.totalTermFreq - (long)stats.docFreq);
            }
            int pos = (int)this.buffer2.getFilePointer();
            this.buffer2.writeTo(this.finalBuffer, 0);
            this.buffer2.reset();
            int totalBytes = pos + (int)this.postingsWriter.buffer.getFilePointer();
            if (totalBytes > this.finalBuffer.length) {
                this.finalBuffer = ArrayUtil.grow((byte[])this.finalBuffer, (int)totalBytes);
            }
            this.postingsWriter.buffer.writeTo(this.finalBuffer, pos);
            this.postingsWriter.buffer.reset();
            this.spare.bytes = this.finalBuffer;
            this.spare.length = totalBytes;
            this.builder.add(Util.toIntsRef((BytesRef)text, (IntsRef)this.scratchIntsRef), (Object)BytesRef.deepCopyOf((BytesRef)this.spare));
            ++this.termCount;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.termCount > 0) {
                this.out.writeVInt(this.termCount);
                this.out.writeVInt(this.field.number);
                if (this.field.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.out.writeVLong(sumTotalTermFreq);
                }
                this.out.writeVLong(sumDocFreq);
                this.out.writeVInt(docCount);
                FST fst = this.builder.finish();
                fst.save((DataOutput)this.out);
            }
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        private class PostingsWriter
        extends PostingsConsumer {
            private int lastDocID;
            private int lastPos;
            private int lastPayloadLen;
            int docCount;
            RAMOutputStream buffer = new RAMOutputStream();
            int lastOffsetLength;
            int lastOffset;

            private PostingsWriter() {
            }

            public void startDoc(int docID, int termDocFreq) throws IOException {
                int delta = docID - this.lastDocID;
                assert (docID == 0 || delta > 0);
                this.lastDocID = docID;
                ++this.docCount;
                if (TermsWriter.this.field.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.buffer.writeVInt(delta);
                } else if (termDocFreq == 1) {
                    this.buffer.writeVInt(delta << 1 | 1);
                } else {
                    this.buffer.writeVInt(delta << 1);
                    assert (termDocFreq > 0);
                    this.buffer.writeVInt(termDocFreq);
                }
                this.lastPos = 0;
                this.lastOffset = 0;
            }

            public void addPosition(int pos, BytesRef payload, int startOffset, int endOffset) throws IOException {
                assert (payload == null || TermsWriter.this.field.hasPayloads());
                int delta = pos - this.lastPos;
                assert (delta >= 0);
                this.lastPos = pos;
                int payloadLen = 0;
                if (TermsWriter.this.field.hasPayloads()) {
                    int n = payloadLen = payload == null ? 0 : payload.length;
                    if (payloadLen != this.lastPayloadLen) {
                        this.lastPayloadLen = payloadLen;
                        this.buffer.writeVInt(delta << 1 | 1);
                        this.buffer.writeVInt(payloadLen);
                    } else {
                        this.buffer.writeVInt(delta << 1);
                    }
                } else {
                    this.buffer.writeVInt(delta);
                }
                if (TermsWriter.this.field.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) {
                    int offsetDelta = startOffset - this.lastOffset;
                    int offsetLength = endOffset - startOffset;
                    if (offsetLength != this.lastOffsetLength) {
                        this.buffer.writeVInt(offsetDelta << 1 | 1);
                        this.buffer.writeVInt(offsetLength);
                    } else {
                        this.buffer.writeVInt(offsetDelta << 1);
                    }
                    this.lastOffset = startOffset;
                    this.lastOffsetLength = offsetLength;
                }
                if (payloadLen > 0) {
                    this.buffer.writeBytes(payload.bytes, payload.offset, payloadLen);
                }
            }

            public void finishDoc() {
            }

            public PostingsWriter reset() {
                assert (this.buffer.getFilePointer() == 0L);
                this.lastDocID = 0;
                this.docCount = 0;
                this.lastPayloadLen = 0;
                this.lastOffsetLength = -1;
                return this;
            }
        }
    }
}

