/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.diskdv;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

public class DiskDocValuesConsumer
extends DocValuesConsumer {
    static final int BLOCK_SIZE = 16384;
    public static final int DELTA_COMPRESSED = 0;
    public static final int GCD_COMPRESSED = 1;
    public static final int TABLE_COMPRESSED = 2;
    final IndexOutput data;
    final IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DiskDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader((DataOutput)this.data, (String)dataCodec, (int)0);
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader((DataOutput)this.meta, (String)metaCodec, (int)0);
            this.maxDoc = state.segmentInfo.getDocCount();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.addNumericField(field, values, true);
    }

    void addNumericField(FieldInfo field, Iterable<Number> values, boolean optimizeStorage) throws IOException {
        long count = 0L;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        HashSet<Long> uniqueValues = null;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            for (Number nv : values) {
                long v = nv.longValue();
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count != 0L) {
                        gcd = MathUtil.gcd((long)gcd, (long)(v - minValue));
                    }
                }
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                ++count;
            }
        } else {
            for (Number nv : values) {
                ++count;
            }
        }
        long delta = maxValue - minValue;
        int format = uniqueValues != null && (delta < 0L || PackedInts.bitsRequired((long)(uniqueValues.size() - 1)) < PackedInts.bitsRequired((long)delta)) && count <= Integer.MAX_VALUE ? 2 : (gcd != 0L && gcd != 1L ? 1 : 0);
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(format);
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(count);
        this.meta.writeVInt(16384);
        switch (format) {
            case 1: {
                this.meta.writeLong(minValue);
                this.meta.writeLong(gcd);
                BlockPackedWriter quotientWriter = new BlockPackedWriter((DataOutput)this.data, 16384);
                for (Number nv : values) {
                    quotientWriter.add((nv.longValue() - minValue) / gcd);
                }
                quotientWriter.finish();
                break;
            }
            case 0: {
                BlockPackedWriter writer = new BlockPackedWriter((DataOutput)this.data, 16384);
                for (Number nv : values) {
                    writer.add(nv.longValue());
                }
                writer.finish();
                break;
            }
            case 2: {
                Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
                this.meta.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.meta.writeLong(decode[i].longValue());
                    encode.put(decode[i], i);
                }
                int bitsRequired = PackedInts.bitsRequired((long)(uniqueValues.size() - 1));
                PackedInts.Writer ordsWriter = PackedInts.getWriterNoHeader((DataOutput)this.data, (PackedInts.Format)PackedInts.Format.PACKED, (int)((int)count), (int)bitsRequired, (int)1024);
                for (Number nv : values) {
                    ordsWriter.add((long)((Integer)encode.get(nv.longValue())).intValue());
                }
                ordsWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        long count = 0L;
        for (BytesRef v : values) {
            minLength = Math.min(minLength, v.length);
            maxLength = Math.max(maxLength, v.length);
            this.data.writeBytes(v.bytes, v.offset, v.length);
            ++count;
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        this.meta.writeVLong(count);
        this.meta.writeLong(startFP);
        if (minLength != maxLength) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(1);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter((DataOutput)this.data, 16384);
            long addr = 0L;
            for (BytesRef v : values) {
                writer.add(addr += (long)v.length);
            }
            writer.finish();
        }
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)2);
        this.addBinaryField(field, values);
        this.addNumericField(field, docToOrd, false);
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)3);
        this.addBinaryField(field, values);
        this.addNumericField(field, ords, false);
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(0);
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong((long)this.maxDoc);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter((DataOutput)this.data, 16384);
        long addr = 0L;
        for (Number v : docToOrdCount) {
            writer.add(addr += v.longValue());
        }
        writer.finish();
    }

    public void close() throws IOException {
        block6: {
            block5: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                    }
                    if (!(success = true)) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.data, this.meta});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data, this.meta});
        }
    }
}

