/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextKnnVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextKnnVectorsReader
extends KnnVectorsReader {
    private static final BytesRef EMPTY = new BytesRef((CharSequence)"");
    private final SegmentReadState readState;
    private final IndexInput dataIn;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final IntObjectHashMap<FieldEntry> fieldEntries = new IntObjectHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SimpleTextKnnVectorsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"gri");
        String vectorFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"vec");
        boolean success = false;
        try {
            try (ChecksumIndexInput in = readState.directory.openChecksumInput(metaFileName);){
                int fieldNumber = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                while (fieldNumber != -1) {
                    String fieldName = this.readString((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NAME);
                    long vectorDataOffset = this.readLong((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DATA_OFFSET);
                    long vectorDataLength = this.readLong((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DATA_LENGTH);
                    int dimension = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DIMENSION);
                    int size = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.SIZE);
                    int[] docIds = new int[size];
                    for (int i = 0; i < size; ++i) {
                        docIds[i] = this.readInt((IndexInput)in, EMPTY);
                    }
                    assert (!this.fieldEntries.containsKey(fieldNumber));
                    this.fieldEntries.put(fieldNumber, (Object)new FieldEntry(dimension, vectorDataOffset, vectorDataLength, docIds, readState.fieldInfos.fieldInfo(fieldName).getVectorSimilarityFunction()));
                    fieldNumber = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                }
                SimpleTextUtil.checkFooter(in);
                this.dataIn = readState.directory.openInput(vectorFileName, IOContext.DEFAULT);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        if (info == null) {
            return null;
        }
        int dimension = info.getVectorDimension();
        if (dimension == 0) {
            throw new IllegalStateException("KNN vectors readers should not be called on fields that don't enable KNN vectors");
        }
        FieldEntry fieldEntry = (FieldEntry)this.fieldEntries.get(info.number);
        if (fieldEntry == null) {
            return null;
        }
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + field + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        IndexInput bytesSlice = this.dataIn.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new SimpleTextFloatVectorValues(fieldEntry, bytesSlice);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        if (info == null) {
            return null;
        }
        int dimension = info.getVectorDimension();
        if (dimension == 0) {
            throw new IllegalStateException("KNN vectors readers should not be called on fields that don't enable KNN vectors");
        }
        FieldEntry fieldEntry = (FieldEntry)this.fieldEntries.get(info.number);
        if (fieldEntry == null) {
            return null;
        }
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + field + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        IndexInput bytesSlice = this.dataIn.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new SimpleTextByteVectorValues(fieldEntry, bytesSlice);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FloatVectorValues values = this.getFloatVectorValues(field);
        if (target.length != values.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + values.dimension());
        }
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        VectorSimilarityFunction vectorSimilarity = info.getVectorSimilarityFunction();
        for (int ord = 0; ord < values.size(); ++ord) {
            int doc = values.ordToDoc(ord);
            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
            if (knnCollector.earlyTerminated()) break;
            float[] vector = values.vectorValue(ord);
            float score = vectorSimilarity.compare(vector, target);
            knnCollector.collect(doc, score);
            knnCollector.incVisitedCount(1);
        }
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        ByteVectorValues values = this.getByteVectorValues(field);
        if (target.length != values.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + values.dimension());
        }
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        VectorSimilarityFunction vectorSimilarity = info.getVectorSimilarityFunction();
        for (int ord = 0; ord < values.size(); ++ord) {
            int doc = values.ordToDoc(ord);
            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
            if (knnCollector.earlyTerminated()) break;
            byte[] vector = values.vectorValue(ord);
            float score = vectorSimilarity.compare(vector, target);
            knnCollector.collect(doc, score);
            knnCollector.incVisitedCount(1);
        }
    }

    public void checkIntegrity() throws IOException {
        IndexInput clone = this.dataIn.clone();
        clone.seek(0L);
        long footerStartPos = this.dataIn.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        if (footerStartPos == 0L) {
            SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
            return;
        }
        do {
            SimpleTextUtil.readLine((DataInput)input, this.scratch);
        } while (input.getFilePointer() < footerStartPos);
        if (input.getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + input.getFilePointer() + " vs expected=" + footerStartPos, (DataInput)input);
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
    }

    public void close() throws IOException {
        this.dataIn.close();
    }

    private int readInt(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.parseInt(field);
    }

    private long readLong(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.parseLong(field);
    }

    private String readString(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.stripPrefix(field);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)prefix);
    }

    private int parseInt(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Integer.parseInt(this.stripPrefix(prefix));
    }

    private long parseLong(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Long.parseLong(this.stripPrefix(prefix));
    }

    private String stripPrefix(BytesRef prefix) {
        int prefixLen = prefix.length;
        return new String(this.scratch.bytes(), prefixLen, this.scratch.length() - prefixLen, StandardCharsets.UTF_8);
    }

    private record FieldEntry(int dimension, long vectorDataOffset, long vectorDataLength, int[] ordToDoc, VectorSimilarityFunction similarityFunction) {
        int size() {
            return this.ordToDoc.length;
        }
    }

    private static class SimpleTextFloatVectorValues
    extends FloatVectorValues {
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final FieldEntry entry;
        private final IndexInput in;
        private final float[][] values;
        int curOrd;

        SimpleTextFloatVectorValues(FieldEntry entry, IndexInput in) throws IOException {
            this.entry = entry;
            this.in = in;
            this.values = new float[entry.size()][entry.dimension];
            this.curOrd = -1;
            this.readAllVectors();
        }

        private SimpleTextFloatVectorValues(SimpleTextFloatVectorValues other) {
            this.entry = other.entry;
            this.in = other.in.clone();
            this.values = other.values;
            this.curOrd = other.curOrd;
        }

        public int dimension() {
            return this.entry.dimension;
        }

        public int size() {
            return this.entry.size();
        }

        public float[] vectorValue(int ord) {
            return this.values[ord];
        }

        public int ordToDoc(int ord) {
            return this.entry.ordToDoc[ord];
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createSparseIterator();
        }

        public VectorScorer scorer(final float[] target) {
            if (this.size() == 0) {
                return null;
            }
            final SimpleTextFloatVectorValues simpleTextFloatVectorValues = new SimpleTextFloatVectorValues(this);
            final KnnVectorValues.DocIndexIterator iterator = simpleTextFloatVectorValues.iterator();
            return new VectorScorer(){
                final /* synthetic */ SimpleTextFloatVectorValues this$0;
                {
                    this.this$0 = this$0;
                }

                public float score() throws IOException {
                    int ord = iterator.index();
                    return this.this$0.entry.similarityFunction().compare(simpleTextFloatVectorValues.vectorValue(ord), target);
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }

        private void readAllVectors() throws IOException {
            for (float[] value : this.values) {
                this.readVector(value);
            }
        }

        private void readVector(float[] value) throws IOException {
            SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
            String s = new BytesRef(this.scratch.bytes(), 1, this.scratch.length() - 2).utf8ToString();
            String[] floatStrings = s.split(",");
            assert (floatStrings.length == value.length) : " read " + s + " when expecting " + value.length + " floats";
            for (int i = 0; i < floatStrings.length; ++i) {
                value[i] = Float.parseFloat(floatStrings[i]);
            }
        }

        public SimpleTextFloatVectorValues copy() {
            return this;
        }
    }

    private static class SimpleTextByteVectorValues
    extends ByteVectorValues {
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final FieldEntry entry;
        private final IndexInput in;
        private final BytesRef binaryValue;
        private final byte[][] values;
        int curOrd;

        SimpleTextByteVectorValues(FieldEntry entry, IndexInput in) throws IOException {
            this.entry = entry;
            this.in = in;
            this.values = new byte[entry.size()][entry.dimension];
            this.binaryValue = new BytesRef(entry.dimension);
            this.binaryValue.length = this.binaryValue.bytes.length;
            this.curOrd = -1;
            this.readAllVectors();
        }

        private SimpleTextByteVectorValues(SimpleTextByteVectorValues other) {
            this.entry = other.entry;
            this.in = other.in.clone();
            this.values = other.values;
            this.binaryValue = new BytesRef(this.entry.dimension);
            this.binaryValue.length = this.binaryValue.bytes.length;
            this.curOrd = other.curOrd;
        }

        public int dimension() {
            return this.entry.dimension;
        }

        public int size() {
            return this.entry.size();
        }

        public byte[] vectorValue(int ord) {
            this.binaryValue.bytes = this.values[ord];
            return this.binaryValue.bytes;
        }

        public int ordToDoc(int ord) {
            return this.entry.ordToDoc[ord];
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createSparseIterator();
        }

        public VectorScorer scorer(final byte[] target) {
            if (this.size() == 0) {
                return null;
            }
            final SimpleTextByteVectorValues simpleTextByteVectorValues = new SimpleTextByteVectorValues(this);
            return new VectorScorer(){
                KnnVectorValues.DocIndexIterator it;
                final /* synthetic */ SimpleTextByteVectorValues this$0;
                {
                    this.this$0 = this$0;
                    this.it = simpleTextByteVectorValues.iterator();
                }

                public float score() throws IOException {
                    int ord = this.it.index();
                    return this.this$0.entry.similarityFunction().compare(simpleTextByteVectorValues.vectorValue(ord), target);
                }

                public DocIdSetIterator iterator() {
                    return this.it;
                }
            };
        }

        private void readAllVectors() throws IOException {
            for (byte[] value : this.values) {
                this.readVector(value);
            }
        }

        private void readVector(byte[] value) throws IOException {
            SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
            String s = new BytesRef(this.scratch.bytes(), 1, this.scratch.length() - 2).utf8ToString();
            String[] floatStrings = s.split(",");
            assert (floatStrings.length == value.length) : " read " + s + " when expecting " + value.length + " floats";
            for (int i = 0; i < floatStrings.length; ++i) {
                value[i] = (byte)Float.parseFloat(floatStrings[i]);
            }
        }

        public SimpleTextByteVectorValues copy() {
            return this;
        }
    }
}

