/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktreeords.FSTOrdsOutputs;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.OrdsFieldReader;
import org.apache.lucene.codecs.blocktreeords.OrdsSegmentTermsEnumFrame;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public final class OrdsSegmentTermsEnum
extends BaseTermsEnum {
    IndexInput in;
    private OrdsSegmentTermsEnumFrame[] stack;
    private final OrdsSegmentTermsEnumFrame staticFrame;
    OrdsSegmentTermsEnumFrame currentFrame;
    boolean termExists;
    final OrdsFieldReader fr;
    private int targetBeforeCurrentLength;
    private final ByteArrayDataInput scratchReader = new ByteArrayDataInput();
    private int validIndexPrefix;
    private boolean eof;
    final BytesRefBuilder term = new BytesRefBuilder();
    private final FST.BytesReader fstReader;
    private FST.Arc<FSTOrdsOutputs.Output>[] arcs = new FST.Arc[1];
    boolean positioned;
    private final FST.Arc<FSTOrdsOutputs.Output> arc = new FST.Arc();

    OrdsSegmentTermsEnum(OrdsFieldReader fr) throws IOException {
        this.fr = fr;
        this.stack = new OrdsSegmentTermsEnumFrame[0];
        this.staticFrame = new OrdsSegmentTermsEnumFrame(this, -1);
        this.fstReader = fr.index == null ? null : fr.index.getBytesReader();
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.currentFrame = this.staticFrame;
        if (fr.index != null) {
            FST.Arc arc = fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            Object arc = null;
        }
        this.validIndexPrefix = 0;
    }

    void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.parent.in.clone();
        }
    }

    private OrdsSegmentTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            OrdsSegmentTermsEnumFrame[] next = new OrdsSegmentTermsEnumFrame[ArrayUtil.oversize((int)(1 + ord), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new OrdsSegmentTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<FSTOrdsOutputs.Output> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.oversize((int)(1 + ord), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next.length; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        return this.arcs[ord];
    }

    OrdsSegmentTermsEnumFrame pushFrame(FST.Arc<FSTOrdsOutputs.Output> arc, FSTOrdsOutputs.Output frameData, int length) throws IOException {
        this.scratchReader.reset(frameData.bytes().bytes, frameData.bytes().offset, frameData.bytes().length);
        long code = this.scratchReader.readVLong();
        long fpSeek = code >>> 2;
        OrdsSegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.hasTermsOrig = f.hasTerms = (code & 2L) != 0L;
        boolean bl = f.isFloor = (code & 1L) != 0L;
        if (f.isFloor) {
            f.termOrdOrig = frameData.startOrd();
            f.setFloorData(this.scratchReader, frameData.bytes());
        }
        this.pushFrame(arc, fpSeek, length, frameData.startOrd());
        return f;
    }

    OrdsSegmentTermsEnumFrame pushFrame(FST.Arc<FSTOrdsOutputs.Output> arc, long fp, int length, long termOrd) throws IOException {
        OrdsSegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.arc = arc;
        if (f.fpOrig == fp && f.nextEnt != -1) {
            if (f.prefix > this.targetBeforeCurrentLength) {
                f.rewind();
            }
            assert (length == f.prefix);
            assert (termOrd == f.termOrdOrig);
        } else {
            f.nextEnt = -1;
            f.prefix = length;
            f.state.termBlockOrd = 0;
            f.termOrdOrig = termOrd;
            f.termOrd = termOrd;
            f.fpOrig = f.fp = fp;
            f.lastSubFP = -1L;
        }
        return f;
    }

    private boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private boolean setEOF() {
        this.eof = true;
        return true;
    }

    public boolean seekExact(BytesRef target) throws IOException {
        int targetUpto;
        FSTOrdsOutputs.Output output;
        FST.Arc arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.positioned && this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            output = (FSTOrdsOutputs.Output)arc.output();
            OrdsSegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label() == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (arc.output() != OrdsBlockTreeTermsWriter.NO_OUTPUT) {
                    output = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.output());
                }
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                int targetUptoMid = targetUpto;
                int targetLimit2 = Math.min(target.length, this.term.length());
                while (targetUpto < targetLimit2 && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0) {
                    ++targetUpto;
                }
                if (cmp == 0) {
                    cmp = this.term.length() - target.length;
                }
                targetUpto = targetUptoMid;
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = lastFrame.ord;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return true;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output() != null);
            output = (FSTOrdsOutputs.Output)arc.output();
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame((FST.Arc<FSTOrdsOutputs.Output>)arc, OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.nextFinalOutput()), 0);
        }
        this.positioned = true;
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(target);
                if (!this.currentFrame.hasTerms) {
                    this.termExists = false;
                    this.term.setByteAt(targetUpto, (byte)targetLabel);
                    this.term.setLength(1 + targetUpto);
                    return false;
                }
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
                return result == TermsEnum.SeekStatus.FOUND;
            }
            arc = nextArc;
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            assert (arc.output() != null);
            if (arc.output() != OrdsBlockTreeTermsWriter.NO_OUTPUT) {
                output = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.output());
            }
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame((FST.Arc<FSTOrdsOutputs.Output>)arc, OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.nextFinalOutput()), targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(target);
        if (!this.currentFrame.hasTerms) {
            this.termExists = false;
            this.term.setLength(targetUpto);
            return false;
        }
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
        return result == TermsEnum.SeekStatus.FOUND;
    }

    public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
        int targetUpto;
        FSTOrdsOutputs.Output output;
        FST.Arc arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        if (this.positioned && this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            output = (FSTOrdsOutputs.Output)arc.output();
            OrdsSegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label() == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                if (arc.output() != OrdsBlockTreeTermsWriter.NO_OUTPUT) {
                    output = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.output());
                }
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                int targetUptoMid = targetUpto;
                int targetLimit2 = Math.min(target.length, this.term.length());
                while (targetUpto < targetLimit2 && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0) {
                    ++targetUpto;
                }
                if (cmp == 0) {
                    cmp = this.term.length() - target.length;
                }
                targetUpto = targetUptoMid;
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = 0;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output() != null);
            output = (FSTOrdsOutputs.Output)arc.output();
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.currentFrame = this.pushFrame((FST.Arc<FSTOrdsOutputs.Output>)arc, OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.nextFinalOutput()), 0);
        }
        this.positioned = true;
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefix;
                this.currentFrame.scanToFloorFrame(target);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
                if (result == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(target);
                    this.termExists = false;
                    if (this.next() != null) {
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }
                return result;
            }
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            arc = nextArc;
            assert (arc.output() != null);
            if (arc.output() != OrdsBlockTreeTermsWriter.NO_OUTPUT) {
                output = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.output());
            }
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.currentFrame = this.pushFrame((FST.Arc<FSTOrdsOutputs.Output>)arc, OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)arc.nextFinalOutput()), targetUpto);
        }
        this.validIndexPrefix = this.currentFrame.prefix;
        this.currentFrame.scanToFloorFrame(target);
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
        if (result == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(target);
            this.termExists = false;
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }
        return result;
    }

    private void printSeekState(PrintStream out) throws IOException {
        if (this.currentFrame == this.staticFrame) {
            out.println("  no prior seek");
        } else {
            out.println("  prior seek state:");
            int ord = 0;
            boolean isSeekFrame = true;
            while (true) {
                OrdsSegmentTermsEnumFrame f = this.getFrame(ord);
                assert (f != null);
                BytesRef prefix = new BytesRef(this.term.bytes(), 0, f.prefix);
                if (f.nextEnt == -1) {
                    out.println("    frame " + (isSeekFrame ? "(seek)" : "(next)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefix + " prefix=" + ToStringUtils.bytesRefToString((BytesRef)prefix) + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " code=" + ((f.fp << 2) + (long)(f.hasTerms ? 2 : 0) + (long)(f.isFloor ? 1 : 0)) + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd() + " termOrd=" + f.termOrd);
                } else {
                    out.println("    frame " + (isSeekFrame ? "(seek, loaded)" : "(next, loaded)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefix + " prefix=" + ToStringUtils.bytesRefToString((BytesRef)prefix) + " nextEnt=" + f.nextEnt + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " code=" + ((f.fp << 2) + (long)(f.hasTerms ? 2 : 0) + (long)(f.isFloor ? 1 : 0)) + " lastSubFP=" + f.lastSubFP + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd() + " termOrd=" + f.termOrd);
                }
                if (this.fr.index != null) {
                    long code;
                    ByteArrayDataInput reader;
                    long codeOrig;
                    assert (!isSeekFrame || f.arc != null) : "isSeekFrame=" + isSeekFrame + " f.arc=" + String.valueOf(f.arc);
                    if (f.prefix > 0 && isSeekFrame && f.arc.label() != (this.term.byteAt(f.prefix - 1) & 0xFF)) {
                        out.println("      broken seek state: arc.label=" + (char)f.arc.label() + " vs term byte=" + (char)(this.term.byteAt(f.prefix - 1) & 0xFF));
                        throw new RuntimeException("seek state is broken");
                    }
                    FSTOrdsOutputs.Output output = (FSTOrdsOutputs.Output)Util.get(this.fr.index, (BytesRef)prefix);
                    if (output == null) {
                        out.println("      broken seek state: prefix is not final in index");
                        throw new RuntimeException("seek state is broken");
                    }
                    if (isSeekFrame && !f.isFloor && (codeOrig = (reader = new ByteArrayDataInput(output.bytes().bytes, output.bytes().offset, output.bytes().length)).readVLong()) != (code = f.fp << 2 | (long)(f.hasTerms ? 2 : 0) | (long)(f.isFloor ? 1 : 0))) {
                        out.println("      broken seek state: output code=" + codeOrig + " doesn't match frame code=" + code);
                        throw new RuntimeException("seek state is broken");
                    }
                }
                if (f == this.currentFrame) break;
                if (f.prefix == this.validIndexPrefix) {
                    isSeekFrame = false;
                }
                ++ord;
            }
        }
    }

    public BytesRef next() throws IOException {
        if (this.in == null) {
            FST.Arc arc;
            if (this.fr.index != null) {
                arc = this.fr.index.getFirstArc(this.arcs[0]);
                assert (arc.isFinal());
            } else {
                arc = null;
            }
            this.currentFrame = this.pushFrame((FST.Arc<FSTOrdsOutputs.Output>)arc, this.fr.rootCode, 0);
            this.currentFrame.loadBlock();
            this.positioned = true;
        }
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        assert (!this.eof);
        if (this.currentFrame == this.staticFrame || !this.positioned) {
            boolean result = this.seekExact(this.term.get());
            assert (result);
        }
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                continue;
            }
            if (this.currentFrame.ord == 0) {
                assert (this.setEOF());
                this.term.setLength(0);
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                this.positioned = false;
                return null;
            }
            long lastFP = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            if (this.currentFrame.nextEnt == -1 || this.currentFrame.lastSubFP != lastFP) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(lastFP);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.prefix);
        }
        while (true) {
            long prevTermOrd = this.currentFrame.termOrd;
            if (!this.currentFrame.next()) break;
            this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length(), prevTermOrd);
            this.currentFrame.isFloor = false;
            this.currentFrame.loadBlock();
        }
        this.positioned = true;
        return this.term.get();
    }

    public BytesRef term() {
        assert (!this.eof);
        return this.term.get();
    }

    public long ord() {
        assert (!this.eof);
        assert (this.currentFrame.termOrd > 0L);
        return this.currentFrame.termOrd - 1L;
    }

    public int docFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.docFreq;
    }

    public long totalTermFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.totalTermFreq;
    }

    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.state, reuse, flags);
    }

    public ImpactsEnum impacts(int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.impacts(this.fr.fieldInfo, this.currentFrame.state, flags);
    }

    public void seekExact(BytesRef target, TermState otherState) {
        assert (this.clearEOF());
        if (target.compareTo(this.term.get()) != 0 || !this.termExists) {
            assert (otherState != null && otherState instanceof BlockTermState);
            BlockTermState blockState = (BlockTermState)otherState;
            this.currentFrame = this.staticFrame;
            this.currentFrame.state.copyFrom(otherState);
            this.term.copyBytes(target);
            this.currentFrame.metaDataUpto = this.currentFrame.getTermBlockOrd();
            this.currentFrame.termOrd = blockState.ord + 1L;
            assert (this.currentFrame.metaDataUpto > 0);
            this.validIndexPrefix = 0;
        }
        this.positioned = true;
    }

    public TermState termState() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        BlockTermState ts = (BlockTermState)this.currentFrame.state.clone();
        assert (this.currentFrame.termOrd > 0L);
        ts.ord = this.currentFrame.termOrd - 1L;
        return ts;
    }

    public void seekExact(long targetOrd) throws IOException {
        if (targetOrd < 0L || targetOrd >= this.fr.numTerms) {
            throw new IllegalArgumentException("targetOrd out of bounds (got: " + targetOrd + ", numTerms=" + this.fr.numTerms + ")");
        }
        assert (this.clearEOF());
        InputOutput io = this.getByOutput(targetOrd);
        this.term.grow(io.input.length);
        Util.toBytesRef((IntsRef)io.input, (BytesRefBuilder)this.term);
        this.currentFrame = io.input.length == 0 ? this.staticFrame : this.getFrame(io.input.length - 1);
        FST.Arc<FSTOrdsOutputs.Output> arc = this.getArc(io.input.length);
        this.targetBeforeCurrentLength = Integer.MAX_VALUE;
        this.currentFrame = this.pushFrame(arc, io.output, io.input.length);
        if (this.currentFrame.termOrd > targetOrd) {
            this.currentFrame.rewind();
        }
        this.currentFrame.scanToFloorFrame(targetOrd);
        this.currentFrame.loadBlock();
        while (this.currentFrame.termOrd <= targetOrd) {
            this.currentFrame.next();
        }
        assert (this.currentFrame.termOrd == targetOrd + 1L) : "currentFrame.termOrd=" + this.currentFrame.termOrd + " vs ord=" + targetOrd;
        assert (this.termExists);
        this.validIndexPrefix = 0;
        this.positioned = false;
    }

    public String toString() {
        return "OrdsSegmentTermsEnum(seg=" + String.valueOf((Object)this.fr.parent) + ")";
    }

    private InputOutput getByOutput(long targetOrd) throws IOException {
        IntsRefBuilder result = new IntsRefBuilder();
        this.fr.index.getFirstArc(this.arc);
        FSTOrdsOutputs.Output output = (FSTOrdsOutputs.Output)this.arc.output();
        int upto = 0;
        int bestUpto = 0;
        FSTOrdsOutputs.Output bestOutput = null;
        block0: while (true) {
            FSTOrdsOutputs.Output finalOutput;
            if (this.arc.isFinal() && targetOrd >= (finalOutput = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)this.arc.nextFinalOutput())).startOrd() && targetOrd <= Long.MAX_VALUE - finalOutput.endOrd()) {
                bestOutput = finalOutput;
                bestUpto = upto;
            }
            if (!FST.targetHasArcs(this.arc)) break;
            result.grow(1 + upto);
            this.fr.index.readFirstRealTargetArc(this.arc.target(), this.arc, this.fstReader);
            if (this.arc.bytesPerArc() != 0 && this.arc.nodeFlags() == 32) {
                int low = 0;
                int high = this.arc.numArcs() - 1;
                int mid = 0;
                boolean found = false;
                while (low <= high) {
                    mid = low + high >>> 1;
                    this.fstReader.setPosition(this.arc.posArcsStart());
                    this.fstReader.skipBytes((long)this.arc.bytesPerArc() * (long)mid);
                    byte flags = this.fstReader.readByte();
                    this.fr.index.readLabel((DataInput)this.fstReader);
                    FSTOrdsOutputs.Output minArcOutput = (flags & 0x10) != 0 ? OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, OrdsBlockTreeTermsWriter.FST_OUTPUTS.read((DataInput)this.fstReader)) : output;
                    if (targetOrd > Long.MAX_VALUE - minArcOutput.endOrd()) {
                        low = mid + 1;
                        continue;
                    }
                    if (targetOrd < minArcOutput.startOrd()) {
                        high = mid - 1;
                        continue;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    result.setLength(bestUpto);
                    InputOutput io = new InputOutput();
                    io.input = result.get();
                    io.output = bestOutput;
                    return io;
                }
                this.fr.index.readArcByIndex(this.arc, this.fstReader, mid);
                result.setIntAt(upto++, this.arc.label());
                output = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)this.arc.output());
                continue;
            }
            while (true) {
                FSTOrdsOutputs.Output minArcOutput = OrdsBlockTreeTermsWriter.FST_OUTPUTS.add(output, (FSTOrdsOutputs.Output)this.arc.output());
                long endOrd = Long.MAX_VALUE - minArcOutput.endOrd();
                if (targetOrd >= minArcOutput.startOrd() && targetOrd <= endOrd) {
                    output = minArcOutput;
                    result.setIntAt(upto++, this.arc.label());
                    continue block0;
                }
                if (targetOrd < endOrd || this.arc.isLast()) {
                    result.setLength(bestUpto);
                    InputOutput io = new InputOutput();
                    io.input = result.get();
                    assert (bestOutput != null);
                    io.output = bestOutput;
                    return io;
                }
                this.fr.index.readNextRealArc(this.arc, this.fstReader);
            }
            break;
        }
        result.setLength(bestUpto);
        InputOutput io = new InputOutput();
        io.input = result.get();
        io.output = bestOutput;
        return io;
    }

    private static class InputOutput {
        public IntsRef input;
        public FSTOrdsOutputs.Output output;

        private InputOutput() {
        }

        public String toString() {
            return "InputOutput(input=" + String.valueOf(this.input) + " output=" + String.valueOf(this.output) + ")";
        }
    }
}

