/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.SimpleNaiveBayesClassifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.BytesRef;

public class CachingNaiveBayesClassifier
extends SimpleNaiveBayesClassifier {
    private final ArrayList<BytesRef> cclasses = new ArrayList();
    private final Map<String, Map<BytesRef, Integer>> termCClassHitCache = new HashMap<String, Map<BytesRef, Integer>>();
    private final Map<BytesRef, Double> classTermFreq = new HashMap<BytesRef, Double>();
    private boolean justCachedTerms;
    private int docsWithClassSize;

    public CachingNaiveBayesClassifier(LeafReader leafReader, Analyzer analyzer, Query query, String classFieldName, String ... textFieldNames) {
        super(leafReader, analyzer, query, classFieldName, textFieldNames);
        try {
            this.reInitCache(0, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<ClassificationResult<BytesRef>> assignClassNormalizedList(String inputDocument) throws IOException {
        String[] tokenizedText = this.tokenize(inputDocument);
        List<ClassificationResult<BytesRef>> assignedClasses = this.calculateLogLikelihood(tokenizedText);
        ArrayList<ClassificationResult<BytesRef>> asignedClassesNorm = super.normClassificationResults(assignedClasses);
        return asignedClassesNorm;
    }

    private List<ClassificationResult<BytesRef>> calculateLogLikelihood(String[] tokenizedText) throws IOException {
        ArrayList<ClassificationResult<BytesRef>> ret = new ArrayList<ClassificationResult<BytesRef>>();
        for (BytesRef cclass : this.cclasses) {
            ClassificationResult<BytesRef> cr = new ClassificationResult<BytesRef>(cclass, 0.0);
            ret.add(cr);
        }
        for (String word : tokenizedText) {
            Map<BytesRef, Integer> hitsInClasses = this.getWordFreqForClassess(word);
            for (BytesRef cclass : this.cclasses) {
                Integer hitsI = hitsInClasses.get(cclass);
                int hits = 0;
                if (hitsI != null) {
                    hits = hitsI;
                }
                double num = hits + 1;
                double den = this.classTermFreq.get(cclass) + (double)this.docsWithClassSize;
                double wordProbability = num / den;
                int removeIdx = -1;
                int i = 0;
                for (ClassificationResult<BytesRef> cr : ret) {
                    if (cr.getAssignedClass().equals((Object)cclass)) {
                        removeIdx = i;
                        break;
                    }
                    ++i;
                }
                if (removeIdx < 0) continue;
                ClassificationResult<BytesRef> toRemove = ret.get(removeIdx);
                ret.add(new ClassificationResult<BytesRef>(toRemove.getAssignedClass(), toRemove.getScore() + Math.log(wordProbability)));
                ret.remove(removeIdx);
            }
        }
        return ret;
    }

    private Map<BytesRef, Integer> getWordFreqForClassess(String word) throws IOException {
        Map<BytesRef, Integer> insertPoint = this.termCClassHitCache.get(word);
        if (insertPoint != null && !insertPoint.isEmpty()) {
            return insertPoint;
        }
        ConcurrentHashMap<BytesRef, Integer> searched = new ConcurrentHashMap<BytesRef, Integer>();
        if (insertPoint != null || !this.justCachedTerms) {
            for (BytesRef cclass : this.cclasses) {
                BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
                BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
                for (String textFieldName : this.textFieldNames) {
                    subQuery.add(new BooleanClause((Query)new TermQuery(new Term(textFieldName, word)), BooleanClause.Occur.SHOULD));
                }
                booleanQuery.add(new BooleanClause((Query)subQuery.build(), BooleanClause.Occur.MUST));
                booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(this.classFieldName, cclass)), BooleanClause.Occur.MUST));
                if (this.query != null) {
                    booleanQuery.add(this.query, BooleanClause.Occur.MUST);
                }
                TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                this.indexSearcher.search((Query)booleanQuery.build(), (Collector)totalHitCountCollector);
                int ret = totalHitCountCollector.getTotalHits();
                if (ret == 0) continue;
                searched.put(cclass, ret);
            }
            if (insertPoint != null) {
                this.termCClassHitCache.put(word, searched);
            }
        }
        return searched;
    }

    public void reInitCache(int minTermOccurrenceInCache, boolean justCachedTerms) throws IOException {
        this.justCachedTerms = justCachedTerms;
        this.docsWithClassSize = this.countDocsWithClass();
        this.termCClassHitCache.clear();
        this.cclasses.clear();
        this.classTermFreq.clear();
        HashMap<String, Long> frequencyMap = new HashMap<String, Long>();
        for (String textFieldName : this.textFieldNames) {
            TermsEnum termsEnum = this.leafReader.terms(textFieldName).iterator();
            while (termsEnum.next() != null) {
                BytesRef term = termsEnum.term();
                String termText = term.utf8ToString();
                long frequency = termsEnum.docFreq();
                Long lastfreq = (Long)frequencyMap.get(termText);
                if (lastfreq != null) {
                    frequency += lastfreq.longValue();
                }
                frequencyMap.put(termText, frequency);
            }
        }
        for (Map.Entry entry : frequencyMap.entrySet()) {
            if ((Long)entry.getValue() <= (long)minTermOccurrenceInCache) continue;
            this.termCClassHitCache.put((String)entry.getKey(), new ConcurrentHashMap());
        }
        Terms terms = MultiFields.getTerms((IndexReader)this.leafReader, (String)this.classFieldName);
        TermsEnum termsEnum = terms.iterator();
        while (termsEnum.next() != null) {
            this.cclasses.add(BytesRef.deepCopyOf((BytesRef)termsEnum.term()));
        }
        for (BytesRef cclass : this.cclasses) {
            double avgNumberOfUniqueTerms = 0.0;
            for (String textFieldName : this.textFieldNames) {
                terms = MultiFields.getTerms((IndexReader)this.leafReader, (String)textFieldName);
                long numPostings = terms.getSumDocFreq();
                avgNumberOfUniqueTerms += (double)numPostings / (double)terms.getDocCount();
            }
            int docsWithC = this.leafReader.docFreq(new Term(this.classFieldName, cclass));
            this.classTermFreq.put(cclass, avgNumberOfUniqueTerms * (double)docsWithC);
        }
    }
}

