/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification.utils;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;

public class DatasetSplitter {
    private final double crossValidationRatio;
    private final double testRatio;

    public DatasetSplitter(double testRatio, double crossValidationRatio) {
        this.crossValidationRatio = crossValidationRatio;
        this.testRatio = testRatio;
    }

    public void split(LeafReader originalIndex, Directory trainingIndex, Directory testIndex, Directory crossValidationIndex, Analyzer analyzer, String ... fieldNames) throws IOException {
        IndexWriter testWriter = new IndexWriter(testIndex, new IndexWriterConfig(analyzer));
        IndexWriter cvWriter = new IndexWriter(crossValidationIndex, new IndexWriterConfig(analyzer));
        IndexWriter trainingWriter = new IndexWriter(trainingIndex, new IndexWriterConfig(analyzer));
        try {
            int size = originalIndex.maxDoc();
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)originalIndex);
            TopDocs topDocs = indexSearcher.search((Query)new MatchAllDocsQuery(), Integer.MAX_VALUE);
            FieldType ft = new FieldType(TextField.TYPE_STORED);
            ft.setStoreTermVectors(true);
            ft.setStoreTermVectorOffsets(true);
            ft.setStoreTermVectorPositions(true);
            int b = 0;
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = new Document();
                Document document = originalIndex.document(scoreDoc.doc);
                if (fieldNames != null && fieldNames.length > 0) {
                    for (String fieldName : fieldNames) {
                        IndexableField field = document.getField(fieldName);
                        if (field == null) continue;
                        doc.add((IndexableField)new Field(fieldName, field.stringValue(), ft));
                    }
                } else {
                    for (IndexableField field : document.getFields()) {
                        if (field.readerValue() != null) {
                            doc.add((IndexableField)new Field(field.name(), field.readerValue(), ft));
                            continue;
                        }
                        if (field.binaryValue() != null) {
                            doc.add((IndexableField)new Field(field.name(), field.binaryValue(), ft));
                            continue;
                        }
                        if (field.stringValue() != null) {
                            doc.add((IndexableField)new Field(field.name(), field.stringValue(), ft));
                            continue;
                        }
                        if (field.numericValue() == null) continue;
                        doc.add((IndexableField)new Field(field.name(), field.numericValue().toString(), ft));
                    }
                }
                if (b % 2 == 0 && (double)testWriter.maxDoc() < (double)size * this.testRatio) {
                    testWriter.addDocument((Iterable)doc);
                } else if ((double)cvWriter.maxDoc() < (double)size * this.crossValidationRatio) {
                    cvWriter.addDocument((Iterable)doc);
                } else {
                    trainingWriter.addDocument((Iterable)doc);
                }
                ++b;
            }
            testWriter.commit();
            cvWriter.commit();
            trainingWriter.commit();
            testWriter.forceMerge(3);
            cvWriter.forceMerge(3);
            trainingWriter.forceMerge(3);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            testWriter.close();
            cvWriter.close();
            trainingWriter.close();
        }
    }
}

