/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.Classifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;

public class KNearestNeighborClassifier
implements Classifier<BytesRef> {
    private MoreLikeThis mlt;
    private String[] textFieldNames;
    private String classFieldName;
    private IndexSearcher indexSearcher;
    private final int k;
    private Query query;
    private int minDocsFreq;
    private int minTermFreq;

    public KNearestNeighborClassifier(int k) {
        this.k = k;
    }

    public KNearestNeighborClassifier(int k, int minDocsFreq, int minTermFreq) {
        this.k = k;
        this.minDocsFreq = minDocsFreq;
        this.minTermFreq = minTermFreq;
    }

    @Override
    public ClassificationResult<BytesRef> assignClass(String text) throws IOException {
        TopDocs knnResults = this.knnSearcher(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        ClassificationResult<BytesRef> assignedClass = null;
        double maxscore = -1.7976931348623157E308;
        for (ClassificationResult<BytesRef> cl : assignedClasses) {
            if (!(cl.getScore() > maxscore)) continue;
            assignedClass = cl;
            maxscore = cl.getScore();
        }
        return assignedClass;
    }

    @Override
    public List<ClassificationResult<BytesRef>> getClasses(String text) throws IOException {
        TopDocs knnResults = this.knnSearcher(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        Collections.sort(assignedClasses);
        return assignedClasses;
    }

    @Override
    public List<ClassificationResult<BytesRef>> getClasses(String text, int max) throws IOException {
        TopDocs knnResults = this.knnSearcher(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        Collections.sort(assignedClasses);
        return assignedClasses.subList(0, max);
    }

    private TopDocs knnSearcher(String text) throws IOException {
        if (this.mlt == null) {
            throw new IOException("You must first call Classifier#train");
        }
        BooleanQuery.Builder mltQuery = new BooleanQuery.Builder();
        for (String fieldName : this.textFieldNames) {
            String boost = null;
            this.mlt.setBoost(true);
            if (fieldName.contains("^")) {
                String[] field2boost = fieldName.split("\\^");
                fieldName = field2boost[0];
                boost = field2boost[1];
            }
            if (boost != null) {
                this.mlt.setBoostFactor(Float.parseFloat(boost));
            }
            mltQuery.add(new BooleanClause(this.mlt.like(fieldName, new Reader[]{new StringReader(text)}), BooleanClause.Occur.SHOULD));
            this.mlt.setBoostFactor(1.0f);
        }
        WildcardQuery classFieldQuery = new WildcardQuery(new Term(this.classFieldName, "*"));
        mltQuery.add(new BooleanClause((Query)classFieldQuery, BooleanClause.Occur.MUST));
        if (this.query != null) {
            mltQuery.add(this.query, BooleanClause.Occur.MUST);
        }
        return this.indexSearcher.search((Query)mltQuery.build(), this.k);
    }

    private List<ClassificationResult<BytesRef>> buildListFromTopDocs(TopDocs topDocs) throws IOException {
        HashMap<BytesRef, Integer> classCounts = new HashMap<BytesRef, Integer>();
        HashMap<BytesRef, Double> classBoosts = new HashMap<BytesRef, Double>();
        float maxScore = topDocs.getMaxScore();
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            IndexableField indexableField = this.indexSearcher.doc(scoreDoc.doc).getField(this.classFieldName);
            if (indexableField == null) continue;
            BytesRef cl = new BytesRef((CharSequence)indexableField.stringValue());
            Integer count = (Integer)classCounts.get(cl);
            if (count != null) {
                classCounts.put(cl, count + 1);
            } else {
                classCounts.put(cl, 1);
            }
            Double totalBoost = (Double)classBoosts.get(cl);
            double singleBoost = scoreDoc.score / maxScore;
            if (totalBoost != null) {
                classBoosts.put(cl, totalBoost + singleBoost);
                continue;
            }
            classBoosts.put(cl, singleBoost);
        }
        ArrayList<ClassificationResult<BytesRef>> returnList = new ArrayList<ClassificationResult<BytesRef>>();
        ArrayList<ClassificationResult<BytesRef>> temporaryList = new ArrayList<ClassificationResult<BytesRef>>();
        int sumdoc = 0;
        for (Map.Entry entry : classCounts.entrySet()) {
            Integer count = (Integer)entry.getValue();
            Double normBoost = (Double)classBoosts.get(entry.getKey()) / (double)count.intValue();
            temporaryList.add(new ClassificationResult<BytesRef>(((BytesRef)entry.getKey()).clone(), (double)count.intValue() * normBoost / (double)this.k));
            sumdoc += count.intValue();
        }
        if (sumdoc < this.k) {
            for (ClassificationResult classificationResult : temporaryList) {
                returnList.add(new ClassificationResult(classificationResult.getAssignedClass(), classificationResult.getScore() * (double)this.k / (double)sumdoc));
            }
        } else {
            returnList = temporaryList;
        }
        return returnList;
    }

    @Override
    public void train(LeafReader leafReader, String textFieldName, String classFieldName, Analyzer analyzer) throws IOException {
        this.train(leafReader, textFieldName, classFieldName, analyzer, null);
    }

    @Override
    public void train(LeafReader leafReader, String textFieldName, String classFieldName, Analyzer analyzer, Query query) throws IOException {
        this.train(leafReader, new String[]{textFieldName}, classFieldName, analyzer, query);
    }

    @Override
    public void train(LeafReader leafReader, String[] textFieldNames, String classFieldName, Analyzer analyzer, Query query) throws IOException {
        this.textFieldNames = textFieldNames;
        this.classFieldName = classFieldName;
        this.mlt = new MoreLikeThis((IndexReader)leafReader);
        this.mlt.setAnalyzer(analyzer);
        this.mlt.setFieldNames(textFieldNames);
        this.indexSearcher = new IndexSearcher((IndexReader)leafReader);
        if (this.minDocsFreq > 0) {
            this.mlt.setMinDocFreq(this.minDocsFreq);
        }
        if (this.minTermFreq > 0) {
            this.mlt.setMinTermFreq(this.minTermFreq);
        }
        this.query = query;
    }
}

