/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification.utils;

import java.io.IOException;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class DocToDoubleVectorUtils {
    private DocToDoubleVectorUtils() {
    }

    public static Double[] toSparseLocalFreqDoubleArray(Terms docTerms, Terms fieldTerms) throws IOException {
        TermsEnum fieldTermsEnum = fieldTerms.iterator(null);
        Double[] freqVector = null;
        if (docTerms != null && fieldTerms.size() > -1L) {
            BytesRef term;
            freqVector = new Double[(int)fieldTerms.size()];
            int i = 0;
            TermsEnum docTermsEnum = docTerms.iterator(null);
            while ((term = fieldTermsEnum.next()) != null) {
                TermsEnum.SeekStatus seekStatus = docTermsEnum.seekCeil(term);
                if (seekStatus.equals((Object)TermsEnum.SeekStatus.END)) {
                    docTermsEnum = docTerms.iterator(null);
                }
                if (seekStatus.equals((Object)TermsEnum.SeekStatus.FOUND)) {
                    long termFreqLocal = docTermsEnum.totalTermFreq();
                    freqVector[i] = Long.valueOf(termFreqLocal).doubleValue();
                } else {
                    freqVector[i] = 0.0;
                }
                ++i;
            }
        }
        return freqVector;
    }

    public static Double[] toDenseLocalFreqDoubleArray(Terms docTerms) throws IOException {
        Double[] freqVector = null;
        if (docTerms != null) {
            freqVector = new Double[(int)docTerms.size()];
            int i = 0;
            TermsEnum docTermsEnum = docTerms.iterator(null);
            while (docTermsEnum.next() != null) {
                long termFreqLocal = docTermsEnum.totalTermFreq();
                freqVector[i] = Long.valueOf(termFreqLocal).doubleValue();
                ++i;
            }
        }
        return freqVector;
    }
}

