/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Locale;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class SearchWithSortTask
extends ReadTask {
    private Sort sort;

    public SearchWithSortTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setParams(String sortField) {
        super.setParams(sortField);
        String[] fields = sortField.split(",");
        SortField[] sortFields = new SortField[fields.length];
        int upto = 0;
        for (int i = 0; i < fields.length; ++i) {
            SortField sortField0;
            String field = fields[i];
            if (field.equals("doc")) {
                sortField0 = SortField.FIELD_DOC;
            } else if (field.equals("score")) {
                sortField0 = SortField.FIELD_SCORE;
            } else {
                int index = field.lastIndexOf(58);
                if (index == -1) {
                    throw new RuntimeException("You must specify the sort type ie page:int,subject:string");
                }
                String fieldName = field.substring(0, index);
                String typeString = field.substring(1 + index, field.length());
                sortField0 = new SortField(fieldName, SortField.Type.valueOf((String)typeString.toUpperCase(Locale.ROOT)));
            }
            sortFields[upto++] = sortField0;
        }
        if (upto < sortFields.length) {
            SortField[] newSortFields = new SortField[upto];
            System.arraycopy(sortFields, 0, newSortFields, 0, upto);
            sortFields = newSortFields;
        }
        this.sort = new Sort(sortFields);
    }

    @Override
    public boolean supportsParams() {
        return true;
    }

    @Override
    public QueryMaker getQueryMaker() {
        return this.getRunData().getQueryMaker(this);
    }

    @Override
    public boolean withRetrieve() {
        return false;
    }

    @Override
    public boolean withSearch() {
        return true;
    }

    @Override
    public boolean withTraverse() {
        return false;
    }

    @Override
    public boolean withWarm() {
        return false;
    }

    @Override
    public Sort getSort() {
        if (this.sort == null) {
            throw new IllegalStateException("No sort field was set");
        }
        return this.sort;
    }
}

