/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.AnalyzerFactory;
import org.apache.lucene.util.Version;

public class NewAnalyzerTask
extends PerfTask {
    private List<String> analyzerNames = new ArrayList<String>();
    private int current;

    public NewAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    public static final Analyzer createAnalyzer(String className) throws Exception {
        Class<Analyzer> clazz = Class.forName(className).asSubclass(Analyzer.class);
        try {
            Constructor<Analyzer> cnstr = clazz.getConstructor(Version.class);
            return cnstr.newInstance(Version.LATEST);
        }
        catch (NoSuchMethodException nsme) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    @Override
    public int doLogic() throws IOException {
        Object analyzerName = null;
        try {
            AnalyzerFactory factory;
            if (this.current >= this.analyzerNames.size()) {
                this.current = 0;
            }
            analyzerName = this.analyzerNames.get(this.current++);
            Analyzer analyzer = null;
            if (null == analyzerName || 0 == ((String)analyzerName).length()) {
                analyzerName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            }
            if (null != (factory = this.getRunData().getAnalyzerFactories().get(analyzerName))) {
                analyzer = factory.create();
            } else if (((String)analyzerName).contains(".")) {
                if (((String)analyzerName).startsWith("standard.")) {
                    analyzerName = "org.apache.lucene.analysis." + (String)analyzerName;
                }
                analyzer = NewAnalyzerTask.createAnalyzer((String)analyzerName);
            } else {
                try {
                    String coreClassName = "org.apache.lucene.analysis.core." + (String)analyzerName;
                    analyzer = NewAnalyzerTask.createAnalyzer(coreClassName);
                    analyzerName = coreClassName;
                }
                catch (ClassNotFoundException e) {
                    analyzerName = "org.apache.lucene.analysis." + (String)analyzerName;
                    analyzer = NewAnalyzerTask.createAnalyzer((String)analyzerName);
                }
            }
            this.getRunData().setAnalyzer(analyzer);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer: " + analyzerName, e);
        }
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        StreamTokenizer stok = new StreamTokenizer(new StringReader(params));
        stok.quoteChar(34);
        stok.quoteChar(39);
        stok.eolIsSignificant(false);
        stok.ordinaryChar(44);
        try {
            block7: while (stok.nextToken() != -1) {
                switch (stok.ttype) {
                    case 44: {
                        continue block7;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        this.analyzerNames.add(stok.sval);
                        continue block7;
                    }
                }
                throw new RuntimeException("Unexpected token: " + stok.toString());
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Line #")) {
                throw e;
            }
            throw new RuntimeException("Line #" + (stok.lineno() + this.getAlgLineNum()) + ": ", e);
        }
        catch (Throwable t) {
            throw new RuntimeException("Line #" + (stok.lineno() + this.getAlgLineNum()) + ": ", t);
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

