/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class StreamUtils {
    public static final int BUFFER_SIZE = 65536;
    private static final Map<String, Type> extensionToType = new HashMap<String, Type>();

    public static InputStream inputStream(Path file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]), 65536);
        return StreamUtils.fileType(file).inputStream(in);
    }

    private static Type fileType(Path file) {
        Type type = null;
        String fileName = file.getFileName().toString();
        int idx = fileName.lastIndexOf(46);
        if (idx != -1) {
            type = extensionToType.get(fileName.substring(idx).toLowerCase(Locale.ROOT));
        }
        return type == null ? Type.PLAIN : type;
    }

    public static OutputStream outputStream(Path file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]), 65536);
        return StreamUtils.fileType(file).outputStream(os);
    }

    static {
        extensionToType.put(".bz2", Type.BZIP2);
        extensionToType.put(".bzip", Type.BZIP2);
        extensionToType.put(".gz", Type.GZIP);
        extensionToType.put(".gzip", Type.GZIP);
    }

    public static enum Type {
        BZIP2("bzip2"),
        GZIP("gz"),
        PLAIN(null);

        private final String csfType;

        private Type(String csfType) {
            this.csfType = csfType;
        }

        private InputStream inputStream(InputStream in) throws IOException {
            try {
                return this.csfType == null ? in : new CompressorStreamFactory().createCompressorInputStream(this.csfType, in);
            }
            catch (CompressorException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private OutputStream outputStream(OutputStream os) throws IOException {
            try {
                return this.csfType == null ? os : new CompressorStreamFactory().createCompressorOutputStream(this.csfType, os);
            }
            catch (CompressorException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

