/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.tasks.WriteLineDocTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.util.IOUtils;

public class LineDocSource
extends ContentSource {
    private Path file;
    private BufferedReader reader;
    private int readCount;
    private LineParser docDataLineReader = null;
    private boolean skipHeaderLine = false;

    private synchronized void openFile() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            InputStream is = StreamUtils.inputStream(this.file);
            this.reader = new BufferedReader(new InputStreamReader(is, this.encoding), 65536);
            if (this.skipHeaderLine) {
                this.reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        int myID;
        String line;
        LineDocSource lineDocSource = this;
        synchronized (lineDocSource) {
            line = this.reader.readLine();
            if (line == null) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.openFile();
                return this.getNextDocData(docData);
            }
            if (this.docDataLineReader == null) {
                this.docDataLineReader = this.createDocDataLineReader(line);
                if (this.skipHeaderLine) {
                    return this.getNextDocData(docData);
                }
            }
            myID = this.readCount++;
        }
        docData.clear();
        docData.setID(myID);
        this.docDataLineReader.parseLine(docData, line);
        return docData;
    }

    private LineParser createDocDataLineReader(String line) {
        Object[] header;
        String headIndicator = "FIELDS_HEADER_INDICATOR###\t";
        if (line.startsWith(headIndicator)) {
            header = line.substring(headIndicator.length()).split(Character.toString('\t'));
            this.skipHeaderLine = true;
        } else {
            header = WriteLineDocTask.DEFAULT_FIELDS;
        }
        String docDataLineReaderClassName = this.getConfig().get("line.parser", null);
        if (docDataLineReaderClassName != null) {
            try {
                Class<LineParser> clazz = Class.forName(docDataLineReaderClassName).asSubclass(LineParser.class);
                Constructor<LineParser> cnstr = clazz.getConstructor(String[].class);
                return cnstr.newInstance(new Object[]{header});
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate " + docDataLineReaderClassName, e);
            }
        }
        if (Arrays.deepEquals(header, WriteLineDocTask.DEFAULT_FIELDS)) {
            return new SimpleLineParser((String[])header);
        }
        return new HeaderLineParser((String[])header);
    }

    @Override
    public void resetInputs() throws IOException {
        super.resetInputs();
        this.openFile();
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        String fileName = config.get("docs.file", null);
        if (fileName == null) {
            throw new IllegalArgumentException("docs.file must be set");
        }
        this.file = Paths.get(fileName, new String[0]).toAbsolutePath();
        if (this.encoding == null) {
            this.encoding = IOUtils.UTF_8;
        }
    }

    public static class HeaderLineParser
    extends LineParser {
        private final FieldName[] posToF;

        public HeaderLineParser(String[] header) {
            super(header);
            this.posToF = new FieldName[header.length];
            for (int i = 0; i < header.length; ++i) {
                String f = header[i];
                this.posToF[i] = "docname".equals(f) ? FieldName.NAME : ("doctitle".equals(f) ? FieldName.TITLE : ("docdate".equals(f) ? FieldName.DATE : ("body".equals(f) ? FieldName.BODY : FieldName.PROP)));
            }
        }

        @Override
        public void parseLine(DocData docData, String line) {
            int k2;
            int n = 0;
            int k1 = 0;
            while ((k2 = line.indexOf(9, k1)) >= 0) {
                if (n >= this.header.length) {
                    throw new RuntimeException("input line has invalid format: " + (n + 1) + " fields instead of " + this.header.length + " :: [" + line + "]");
                }
                this.setDocDataField(docData, n, line.substring(k1, k2));
                ++n;
                k1 = k2 + 1;
            }
            if (n != this.header.length - 1) {
                throw new RuntimeException("input line has invalid format: " + (n + 1) + " fields instead of " + this.header.length + " :: [" + line + "]");
            }
            this.setDocDataField(docData, n, line.substring(k1));
        }

        private void setDocDataField(DocData docData, int position, String text) {
            switch (this.posToF[position]) {
                case NAME: {
                    docData.setName(text);
                    break;
                }
                case TITLE: {
                    docData.setTitle(text);
                    break;
                }
                case DATE: {
                    docData.setDate(text);
                    break;
                }
                case BODY: {
                    docData.setBody(text);
                    break;
                }
                case PROP: {
                    Properties p = docData.getProps();
                    if (p == null) {
                        p = new Properties();
                        docData.setProps(p);
                    }
                    p.setProperty(this.header[position], text);
                }
            }
        }

        private static enum FieldName {
            NAME,
            TITLE,
            DATE,
            BODY,
            PROP;

        }
    }

    public static class SimpleLineParser
    extends LineParser {
        public SimpleLineParser(String[] header) {
            super(header);
        }

        @Override
        public void parseLine(DocData docData, String line) {
            int k1 = 0;
            int k2 = line.indexOf(9, k1);
            if (k2 < 0) {
                throw new RuntimeException("line: [" + line + "] is in an invalid format (missing: separator title::date)!");
            }
            docData.setTitle(line.substring(k1, k2));
            k1 = k2 + 1;
            k2 = line.indexOf(9, k1);
            if (k2 < 0) {
                throw new RuntimeException("line: [" + line + "] is in an invalid format (missing: separator date::body)!");
            }
            docData.setDate(line.substring(k1, k2));
            k1 = k2 + 1;
            k2 = line.indexOf(9, k1);
            if (k2 >= 0) {
                throw new RuntimeException("line: [" + line + "] is in an invalid format (too many separators)!");
            }
            docData.setBody(line.substring(k1));
        }
    }

    public static abstract class LineParser {
        protected final String[] header;

        public LineParser(String[] header) {
            this.header = header;
        }

        public abstract void parseLine(DocData var1, String var2);
    }
}

