/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.feeds.AbstractQueryMaker;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.NewAnalyzerTask;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.IOUtils;

public class FileBasedQueryMaker
extends AbstractQueryMaker
implements QueryMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query[] prepareQueries() throws Exception {
        Analyzer anlzr = NewAnalyzerTask.createAnalyzer(this.config.get("analyzer", "org.apache.lucene.analysis.standard.StandardAnalyzer"));
        String defaultField = this.config.get("file.query.maker.default.field", "body");
        QueryParser qp = new QueryParser(defaultField, anlzr);
        qp.setAllowLeadingWildcard(true);
        ArrayList<Query> qq = new ArrayList<Query>();
        String fileName = this.config.get("file.query.maker.file", null);
        if (fileName != null) {
            Path path = Paths.get(fileName, new String[0]);
            Reader reader = null;
            if (Files.exists(path, new LinkOption[0])) {
                reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            } else {
                InputStream asStream = FileBasedQueryMaker.class.getClassLoader().getResourceAsStream(fileName);
                if (asStream != null) {
                    reader = IOUtils.getDecodingReader((InputStream)asStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (reader != null) {
                try {
                    BufferedReader buffered = new BufferedReader(reader);
                    String line = null;
                    int lineNum = 0;
                    while ((line = buffered.readLine()) != null) {
                        if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                            try {
                                qq.add(qp.parse(line));
                            }
                            catch (ParseException e) {
                                System.err.println("Exception: " + e.getMessage() + " occurred while parsing line: " + lineNum + " Text: " + line);
                            }
                        }
                        ++lineNum;
                    }
                }
                finally {
                    reader.close();
                }
            }
            System.err.println("No Reader available for: " + fileName);
        }
        return qq.toArray(new Query[qq.size()]);
    }
}

