/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;

public final class AnalyzerFactory {
    private final List<CharFilterFactory> charFilterFactories;
    private final TokenizerFactory tokenizerFactory;
    private final List<TokenFilterFactory> tokenFilterFactories;
    private String name = null;
    private Integer positionIncrementGap = null;
    private Integer offsetGap = null;

    public AnalyzerFactory(List<CharFilterFactory> charFilterFactories, TokenizerFactory tokenizerFactory, List<TokenFilterFactory> tokenFilterFactories) {
        this.charFilterFactories = charFilterFactories;
        assert (null != tokenizerFactory);
        this.tokenizerFactory = tokenizerFactory;
        this.tokenFilterFactories = tokenFilterFactories;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPositionIncrementGap(Integer positionIncrementGap) {
        this.positionIncrementGap = positionIncrementGap;
    }

    public void setOffsetGap(Integer offsetGap) {
        this.offsetGap = offsetGap;
    }

    public Analyzer create() {
        return new Analyzer(){
            private final Integer positionIncrementGap;
            private final Integer offsetGap;
            {
                this.positionIncrementGap = AnalyzerFactory.this.positionIncrementGap;
                this.offsetGap = AnalyzerFactory.this.offsetGap;
            }

            public Reader initReader(String fieldName, Reader reader) {
                if (AnalyzerFactory.this.charFilterFactories != null && AnalyzerFactory.this.charFilterFactories.size() > 0) {
                    Reader wrappedReader = reader;
                    for (CharFilterFactory charFilterFactory : AnalyzerFactory.this.charFilterFactories) {
                        wrappedReader = charFilterFactory.create(wrappedReader);
                    }
                    reader = wrappedReader;
                }
                return reader;
            }

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                Tokenizer tokenizer;
                Tokenizer tokenStream = tokenizer = AnalyzerFactory.this.tokenizerFactory.create();
                for (TokenFilterFactory filterFactory : AnalyzerFactory.this.tokenFilterFactories) {
                    tokenStream = filterFactory.create((TokenStream)tokenStream);
                }
                return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)tokenStream);
            }

            public int getPositionIncrementGap(String fieldName) {
                return null == this.positionIncrementGap ? super.getPositionIncrementGap(fieldName) : this.positionIncrementGap.intValue();
            }

            public int getOffsetGap(String fieldName) {
                return null == this.offsetGap ? super.getOffsetGap(fieldName) : this.offsetGap.intValue();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AnalyzerFactory(");
        if (null != this.name) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(", ");
        }
        if (null != this.positionIncrementGap) {
            sb.append("positionIncrementGap:");
            sb.append(this.positionIncrementGap);
            sb.append(", ");
        }
        if (null != this.offsetGap) {
            sb.append("offsetGap:");
            sb.append(this.offsetGap);
            sb.append(", ");
        }
        for (CharFilterFactory charFilterFactory : this.charFilterFactories) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizerFactory);
        for (TokenFilterFactory tokenFilterFactory : this.tokenFilterFactories) {
            sb.append(", ");
            sb.append(tokenFilterFactory);
        }
        sb.append(')');
        return sb.toString();
    }
}

