/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class WriteLineDocTask
extends PerfTask {
    public static final String FIELDS_HEADER_INDICATOR = "FIELDS_HEADER_INDICATOR###";
    public static final char SEP = '\t';
    public static final String[] DEFAULT_FIELDS = new String[]{"doctitle", "docdate", "body"};
    public static final String DEFAULT_SUFFICIENT_FIELDS = "doctitle,body";
    private int docSize = 0;
    protected final String fname;
    private final PrintWriter lineFileOut;
    private final DocMaker docMaker;
    private final ThreadLocal<StringBuilder> threadBuffer = new ThreadLocal();
    private final ThreadLocal<Matcher> threadNormalizer = new ThreadLocal();
    private final String[] fieldsToWrite;
    private final boolean[] sufficientFields;
    private final boolean checkSufficientFields;

    public WriteLineDocTask(PerfRunData runData) throws Exception {
        super(runData);
        Config config = runData.getConfig();
        this.fname = config.get("line.file.out", null);
        if (this.fname == null) {
            throw new IllegalArgumentException("line.file.out must be set");
        }
        OutputStream out = StreamUtils.outputStream(new File(this.fname));
        this.lineFileOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 65536));
        this.docMaker = runData.getDocMaker();
        String f2r = config.get("line.fields", null);
        if (f2r == null) {
            this.fieldsToWrite = DEFAULT_FIELDS;
        } else {
            if (f2r.indexOf(9) >= 0) {
                throw new IllegalArgumentException("line.fields " + f2r + " should not contain the separator char: " + '\t');
            }
            this.fieldsToWrite = f2r.split(",");
        }
        this.sufficientFields = new boolean[this.fieldsToWrite.length];
        String suff = config.get("sufficient.fields", DEFAULT_SUFFICIENT_FIELDS);
        if (",".equals(suff)) {
            this.checkSufficientFields = false;
        } else {
            this.checkSufficientFields = true;
            HashSet<String> sf = new HashSet<String>(Arrays.asList(suff.split(",")));
            for (int i = 0; i < this.fieldsToWrite.length; ++i) {
                if (!sf.contains(this.fieldsToWrite[i])) continue;
                this.sufficientFields[i] = true;
            }
        }
        this.writeHeader(this.lineFileOut);
    }

    protected void writeHeader(PrintWriter out) {
        StringBuilder sb = this.threadBuffer.get();
        if (sb == null) {
            sb = new StringBuilder();
            this.threadBuffer.set(sb);
        }
        sb.setLength(0);
        sb.append(FIELDS_HEADER_INDICATOR);
        for (String f : this.fieldsToWrite) {
            sb.append('\t').append(f);
        }
        out.println(sb.toString());
    }

    @Override
    protected String getLogMessage(int recsCount) {
        return "Wrote " + recsCount + " line docs";
    }

    @Override
    public int doLogic() throws Exception {
        StringBuilder sb;
        Document doc = this.docSize > 0 ? this.docMaker.makeDocument(this.docSize) : this.docMaker.makeDocument();
        Matcher matcher = this.threadNormalizer.get();
        if (matcher == null) {
            matcher = Pattern.compile("[\t\r\n]+").matcher("");
            this.threadNormalizer.set(matcher);
        }
        if ((sb = this.threadBuffer.get()) == null) {
            sb = new StringBuilder();
            this.threadBuffer.set(sb);
        }
        sb.setLength(0);
        boolean sufficient = !this.checkSufficientFields;
        for (int i = 0; i < this.fieldsToWrite.length; ++i) {
            IndexableField f = doc.getField(this.fieldsToWrite[i]);
            String text = f == null ? "" : matcher.reset(f.stringValue()).replaceAll(" ").trim();
            sb.append(text).append('\t');
            sufficient |= text.length() > 0 && this.sufficientFields[i];
        }
        if (sufficient) {
            sb.setLength(sb.length() - 1);
            this.lineFileOut(doc).println(sb.toString());
        }
        return 1;
    }

    protected PrintWriter lineFileOut(Document doc) {
        return this.lineFileOut;
    }

    @Override
    public void close() throws Exception {
        this.lineFileOut.close();
        super.close();
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

